/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.health.AWSHealth;
import com.amazonaws.services.health.AWSHealthClientBuilder;
import com.amazonaws.services.health.model.AWSHealthException;
import com.amazonaws.services.health.model.DescribeAffectedAccountsForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeAffectedAccountsForOrganizationResult;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesForOrganizationResult;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesRequest;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesResult;
import com.amazonaws.services.health.model.DescribeEntityAggregatesRequest;
import com.amazonaws.services.health.model.DescribeEntityAggregatesResult;
import com.amazonaws.services.health.model.DescribeEventAggregatesRequest;
import com.amazonaws.services.health.model.DescribeEventAggregatesResult;
import com.amazonaws.services.health.model.DescribeEventDetailsForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeEventDetailsForOrganizationResult;
import com.amazonaws.services.health.model.DescribeEventDetailsRequest;
import com.amazonaws.services.health.model.DescribeEventDetailsResult;
import com.amazonaws.services.health.model.DescribeEventTypesRequest;
import com.amazonaws.services.health.model.DescribeEventTypesResult;
import com.amazonaws.services.health.model.DescribeEventsForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeEventsForOrganizationResult;
import com.amazonaws.services.health.model.DescribeEventsRequest;
import com.amazonaws.services.health.model.DescribeEventsResult;
import com.amazonaws.services.health.model.DescribeHealthServiceStatusForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeHealthServiceStatusForOrganizationResult;
import com.amazonaws.services.health.model.DisableHealthServiceAccessForOrganizationRequest;
import com.amazonaws.services.health.model.DisableHealthServiceAccessForOrganizationResult;
import com.amazonaws.services.health.model.EnableHealthServiceAccessForOrganizationRequest;
import com.amazonaws.services.health.model.EnableHealthServiceAccessForOrganizationResult;
import com.amazonaws.services.health.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeAffectedAccountsForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeAffectedAccountsForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeAffectedEntitiesForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeAffectedEntitiesForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeAffectedEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeAffectedEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEntityAggregatesRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEntityAggregatesResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventAggregatesRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventAggregatesResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventDetailsForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventDetailsForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventDetailsRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventDetailsResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventTypesRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventTypesResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventsForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventsForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventsRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeEventsResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DescribeHealthServiceStatusForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DescribeHealthServiceStatusForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.DisableHealthServiceAccessForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.DisableHealthServiceAccessForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.EnableHealthServiceAccessForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.health.model.transform.EnableHealthServiceAccessForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.health.model.transform.InvalidPaginationTokenExceptionUnmarshaller;
import com.amazonaws.services.health.model.transform.UnsupportedLocaleExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSHealthClient
extends AmazonWebServiceClient
implements AWSHealth {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSHealth.class);
    private static final String DEFAULT_SIGNING_NAME = "health";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLocale").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedLocaleExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationToken").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidPaginationTokenExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSHealthException.class));

    @Deprecated
    public AWSHealthClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSHealthClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSHealthClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSHealthClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSHealthClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSHealthClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSHealthClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSHealthClientBuilder builder() {
        return AWSHealthClientBuilder.standard();
    }

    AWSHealthClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSHealthClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("health.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/health/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/health/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DescribeAffectedAccountsForOrganizationResult describeAffectedAccountsForOrganization(DescribeAffectedAccountsForOrganizationRequest request) {
        request = (DescribeAffectedAccountsForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeDescribeAffectedAccountsForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAffectedAccountsForOrganizationResult executeDescribeAffectedAccountsForOrganization(DescribeAffectedAccountsForOrganizationRequest describeAffectedAccountsForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAffectedAccountsForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAffectedAccountsForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAffectedAccountsForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((DescribeAffectedAccountsForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAffectedAccountsForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAffectedAccountsForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAffectedAccountsForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAffectedAccountsForOrganizationResult describeAffectedAccountsForOrganizationResult = (DescribeAffectedAccountsForOrganizationResult)response.getAwsResponse();
            return describeAffectedAccountsForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAffectedEntitiesResult describeAffectedEntities(DescribeAffectedEntitiesRequest request) {
        request = (DescribeAffectedEntitiesRequest)this.beforeClientExecution(request);
        return this.executeDescribeAffectedEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAffectedEntitiesResult executeDescribeAffectedEntities(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAffectedEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAffectedEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAffectedEntitiesRequestProtocolMarshaller(protocolFactory).marshall((DescribeAffectedEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAffectedEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAffectedEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAffectedEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAffectedEntitiesResult describeAffectedEntitiesResult = (DescribeAffectedEntitiesResult)response.getAwsResponse();
            return describeAffectedEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAffectedEntitiesForOrganizationResult describeAffectedEntitiesForOrganization(DescribeAffectedEntitiesForOrganizationRequest request) {
        request = (DescribeAffectedEntitiesForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeDescribeAffectedEntitiesForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAffectedEntitiesForOrganizationResult executeDescribeAffectedEntitiesForOrganization(DescribeAffectedEntitiesForOrganizationRequest describeAffectedEntitiesForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAffectedEntitiesForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAffectedEntitiesForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAffectedEntitiesForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((DescribeAffectedEntitiesForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAffectedEntitiesForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAffectedEntitiesForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAffectedEntitiesForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAffectedEntitiesForOrganizationResult describeAffectedEntitiesForOrganizationResult = (DescribeAffectedEntitiesForOrganizationResult)response.getAwsResponse();
            return describeAffectedEntitiesForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEntityAggregatesResult describeEntityAggregates(DescribeEntityAggregatesRequest request) {
        request = (DescribeEntityAggregatesRequest)this.beforeClientExecution(request);
        return this.executeDescribeEntityAggregates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEntityAggregatesResult executeDescribeEntityAggregates(DescribeEntityAggregatesRequest describeEntityAggregatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEntityAggregatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEntityAggregatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEntityAggregatesRequestProtocolMarshaller(protocolFactory).marshall((DescribeEntityAggregatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEntityAggregatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEntityAggregates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntityAggregatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEntityAggregatesResult describeEntityAggregatesResult = (DescribeEntityAggregatesResult)response.getAwsResponse();
            return describeEntityAggregatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventAggregatesResult describeEventAggregates(DescribeEventAggregatesRequest request) {
        request = (DescribeEventAggregatesRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventAggregates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventAggregatesResult executeDescribeEventAggregates(DescribeEventAggregatesRequest describeEventAggregatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventAggregatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventAggregatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventAggregatesRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventAggregatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventAggregatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventAggregates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventAggregatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventAggregatesResult describeEventAggregatesResult = (DescribeEventAggregatesResult)response.getAwsResponse();
            return describeEventAggregatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventDetailsResult describeEventDetails(DescribeEventDetailsRequest request) {
        request = (DescribeEventDetailsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventDetails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventDetailsResult executeDescribeEventDetails(DescribeEventDetailsRequest describeEventDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventDetailsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventDetails");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventDetailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventDetailsResult describeEventDetailsResult = (DescribeEventDetailsResult)response.getAwsResponse();
            return describeEventDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventDetailsForOrganizationResult describeEventDetailsForOrganization(DescribeEventDetailsForOrganizationRequest request) {
        request = (DescribeEventDetailsForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventDetailsForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventDetailsForOrganizationResult executeDescribeEventDetailsForOrganization(DescribeEventDetailsForOrganizationRequest describeEventDetailsForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventDetailsForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventDetailsForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventDetailsForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventDetailsForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventDetailsForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventDetailsForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventDetailsForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventDetailsForOrganizationResult describeEventDetailsForOrganizationResult = (DescribeEventDetailsForOrganizationResult)response.getAwsResponse();
            return describeEventDetailsForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventTypesResult describeEventTypes(DescribeEventTypesRequest request) {
        request = (DescribeEventTypesRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventTypesResult executeDescribeEventTypes(DescribeEventTypesRequest describeEventTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventTypesRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventTypesResult describeEventTypesResult = (DescribeEventTypesResult)response.getAwsResponse();
            return describeEventTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        request = (DescribeEventsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventsResult executeDescribeEvents(DescribeEventsRequest describeEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventsResult describeEventsResult = (DescribeEventsResult)response.getAwsResponse();
            return describeEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventsForOrganizationResult describeEventsForOrganization(DescribeEventsForOrganizationRequest request) {
        request = (DescribeEventsForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventsForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventsForOrganizationResult executeDescribeEventsForOrganization(DescribeEventsForOrganizationRequest describeEventsForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventsForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventsForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventsForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventsForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventsForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventsForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventsForOrganizationResult describeEventsForOrganizationResult = (DescribeEventsForOrganizationResult)response.getAwsResponse();
            return describeEventsForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHealthServiceStatusForOrganizationResult describeHealthServiceStatusForOrganization(DescribeHealthServiceStatusForOrganizationRequest request) {
        request = (DescribeHealthServiceStatusForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeDescribeHealthServiceStatusForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeHealthServiceStatusForOrganizationResult executeDescribeHealthServiceStatusForOrganization(DescribeHealthServiceStatusForOrganizationRequest describeHealthServiceStatusForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHealthServiceStatusForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHealthServiceStatusForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHealthServiceStatusForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((DescribeHealthServiceStatusForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHealthServiceStatusForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeHealthServiceStatusForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHealthServiceStatusForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeHealthServiceStatusForOrganizationResult describeHealthServiceStatusForOrganizationResult = (DescribeHealthServiceStatusForOrganizationResult)response.getAwsResponse();
            return describeHealthServiceStatusForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableHealthServiceAccessForOrganizationResult disableHealthServiceAccessForOrganization(DisableHealthServiceAccessForOrganizationRequest request) {
        request = (DisableHealthServiceAccessForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeDisableHealthServiceAccessForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableHealthServiceAccessForOrganizationResult executeDisableHealthServiceAccessForOrganization(DisableHealthServiceAccessForOrganizationRequest disableHealthServiceAccessForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableHealthServiceAccessForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableHealthServiceAccessForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableHealthServiceAccessForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((DisableHealthServiceAccessForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableHealthServiceAccessForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableHealthServiceAccessForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableHealthServiceAccessForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableHealthServiceAccessForOrganizationResult disableHealthServiceAccessForOrganizationResult = (DisableHealthServiceAccessForOrganizationResult)response.getAwsResponse();
            return disableHealthServiceAccessForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableHealthServiceAccessForOrganizationResult enableHealthServiceAccessForOrganization(EnableHealthServiceAccessForOrganizationRequest request) {
        request = (EnableHealthServiceAccessForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeEnableHealthServiceAccessForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableHealthServiceAccessForOrganizationResult executeEnableHealthServiceAccessForOrganization(EnableHealthServiceAccessForOrganizationRequest enableHealthServiceAccessForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableHealthServiceAccessForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableHealthServiceAccessForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableHealthServiceAccessForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((EnableHealthServiceAccessForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableHealthServiceAccessForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Health");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableHealthServiceAccessForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableHealthServiceAccessForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableHealthServiceAccessForOrganizationResult enableHealthServiceAccessForOrganizationResult = (EnableHealthServiceAccessForOrganizationResult)response.getAwsResponse();
            return enableHealthServiceAccessForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

