/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.ListRolesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListRolesRequestMarshaller
implements Marshaller<Request<ListRolesRequest>, ListRolesRequest> {
    public Request<ListRolesRequest> marshall(ListRolesRequest listRolesRequest) {
        if (listRolesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRolesRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "ListRoles");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listRolesRequest.getPathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listRolesRequest.getPathPrefix()));
        }
        if (listRolesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listRolesRequest.getMarker()));
        }
        if (listRolesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listRolesRequest.getMaxItems()));
        }
        return request;
    }
}

