/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.ContextEntry;
import com.amazonaws.services.identitymanagement.model.SimulateCustomPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SimulateCustomPolicyRequestMarshaller
implements Marshaller<Request<SimulateCustomPolicyRequest>, SimulateCustomPolicyRequest> {
    public Request<SimulateCustomPolicyRequest> marshall(SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        if (simulateCustomPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)simulateCustomPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "SimulateCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (!simulateCustomPolicyRequest.getPolicyInputList().isEmpty() || !((SdkInternalList)simulateCustomPolicyRequest.getPolicyInputList()).isAutoConstruct()) {
            SdkInternalList policyInputListList = (SdkInternalList)simulateCustomPolicyRequest.getPolicyInputList();
            int policyInputListListIndex = 1;
            for (String policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (!simulateCustomPolicyRequest.getPermissionsBoundaryPolicyInputList().isEmpty() || !((SdkInternalList)simulateCustomPolicyRequest.getPermissionsBoundaryPolicyInputList()).isAutoConstruct()) {
            SdkInternalList permissionsBoundaryPolicyInputListList = (SdkInternalList)simulateCustomPolicyRequest.getPermissionsBoundaryPolicyInputList();
            int permissionsBoundaryPolicyInputListListIndex = 1;
            for (String permissionsBoundaryPolicyInputListListValue : permissionsBoundaryPolicyInputListList) {
                if (permissionsBoundaryPolicyInputListListValue != null) {
                    request.addParameter("PermissionsBoundaryPolicyInputList.member." + permissionsBoundaryPolicyInputListListIndex, StringUtils.fromString((String)permissionsBoundaryPolicyInputListListValue));
                }
                ++permissionsBoundaryPolicyInputListListIndex;
            }
        }
        if (!simulateCustomPolicyRequest.getActionNames().isEmpty() || !((SdkInternalList)simulateCustomPolicyRequest.getActionNames()).isAutoConstruct()) {
            SdkInternalList actionNamesList = (SdkInternalList)simulateCustomPolicyRequest.getActionNames();
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (!simulateCustomPolicyRequest.getResourceArns().isEmpty() || !((SdkInternalList)simulateCustomPolicyRequest.getResourceArns()).isAutoConstruct()) {
            SdkInternalList resourceArnsList = (SdkInternalList)simulateCustomPolicyRequest.getResourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulateCustomPolicyRequest.getResourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString((String)simulateCustomPolicyRequest.getResourcePolicy()));
        }
        if (simulateCustomPolicyRequest.getResourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)simulateCustomPolicyRequest.getResourceOwner()));
        }
        if (simulateCustomPolicyRequest.getCallerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString((String)simulateCustomPolicyRequest.getCallerArn()));
        }
        if (!simulateCustomPolicyRequest.getContextEntries().isEmpty() || !((SdkInternalList)simulateCustomPolicyRequest.getContextEntries()).isAutoConstruct()) {
            SdkInternalList contextEntriesList = (SdkInternalList)simulateCustomPolicyRequest.getContextEntries();
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                if (contextEntriesListValue.getContextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString((String)contextEntriesListValue.getContextKeyName()));
                }
                if (!contextEntriesListValue.getContextKeyValues().isEmpty() || !((SdkInternalList)contextEntriesListValue.getContextKeyValues()).isAutoConstruct()) {
                    SdkInternalList contextKeyValuesList = (SdkInternalList)contextEntriesListValue.getContextKeyValues();
                    int contextKeyValuesListIndex = 1;
                    for (String contextKeyValuesListValue : contextKeyValuesList) {
                        if (contextKeyValuesListValue != null) {
                            request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString((String)contextKeyValuesListValue));
                        }
                        ++contextKeyValuesListIndex;
                    }
                }
                if (contextEntriesListValue.getContextKeyType() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString((String)contextEntriesListValue.getContextKeyType()));
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulateCustomPolicyRequest.getResourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString((String)simulateCustomPolicyRequest.getResourceHandlingOption()));
        }
        if (simulateCustomPolicyRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)simulateCustomPolicyRequest.getMaxItems()));
        }
        if (simulateCustomPolicyRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)simulateCustomPolicyRequest.getMarker()));
        }
        return request;
    }
}

