/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutRecordRequestMarshaller
implements Marshaller<Request<PutRecordRequest>, PutRecordRequest> {
    public Request<PutRecordRequest> marshall(PutRecordRequest putRecordRequest) {
        if (putRecordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRecordRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.PutRecord");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (putRecordRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(putRecordRequest.getStreamName());
            }
            if (putRecordRequest.getData() != null) {
                jsonGenerator.writeFieldName("Data").writeValue(putRecordRequest.getData());
            }
            if (putRecordRequest.getPartitionKey() != null) {
                jsonGenerator.writeFieldName("PartitionKey").writeValue(putRecordRequest.getPartitionKey());
            }
            if (putRecordRequest.getExplicitHashKey() != null) {
                jsonGenerator.writeFieldName("ExplicitHashKey").writeValue(putRecordRequest.getExplicitHashKey());
            }
            if (putRecordRequest.getSequenceNumberForOrdering() != null) {
                jsonGenerator.writeFieldName("SequenceNumberForOrdering").writeValue(putRecordRequest.getSequenceNumberForOrdering());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

