/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.S3DestinationUpdate;
import com.amazonaws.services.kinesisfirehose.model.transform.BufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.EncryptionConfigurationJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class S3DestinationUpdateJsonMarshaller {
    private static S3DestinationUpdateJsonMarshaller instance;

    public void marshall(S3DestinationUpdate s3DestinationUpdate, SdkJsonGenerator jsonGenerator) {
        if (s3DestinationUpdate == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3DestinationUpdate.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(s3DestinationUpdate.getRoleARN());
            }
            if (s3DestinationUpdate.getBucketARN() != null) {
                jsonGenerator.writeFieldName("BucketARN").writeValue(s3DestinationUpdate.getBucketARN());
            }
            if (s3DestinationUpdate.getPrefix() != null) {
                jsonGenerator.writeFieldName("Prefix").writeValue(s3DestinationUpdate.getPrefix());
            }
            if (s3DestinationUpdate.getBufferingHints() != null) {
                jsonGenerator.writeFieldName("BufferingHints");
                BufferingHintsJsonMarshaller.getInstance().marshall(s3DestinationUpdate.getBufferingHints(), jsonGenerator);
            }
            if (s3DestinationUpdate.getCompressionFormat() != null) {
                jsonGenerator.writeFieldName("CompressionFormat").writeValue(s3DestinationUpdate.getCompressionFormat());
            }
            if (s3DestinationUpdate.getEncryptionConfiguration() != null) {
                jsonGenerator.writeFieldName("EncryptionConfiguration");
                EncryptionConfigurationJsonMarshaller.getInstance().marshall(s3DestinationUpdate.getEncryptionConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DestinationUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DestinationUpdateJsonMarshaller();
        }
        return instance;
    }
}

