/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseAsync;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseAsyncClientBuilder;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClient;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.DeleteDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.DeleteDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.GetKinesisStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.GetKinesisStreamResult;
import com.amazonaws.services.kinesisfirehose.model.ListDeliveryStreamsRequest;
import com.amazonaws.services.kinesisfirehose.model.ListDeliveryStreamsResult;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchResult;
import com.amazonaws.services.kinesisfirehose.model.PutRecordRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordResult;
import com.amazonaws.services.kinesisfirehose.model.UpdateDestinationRequest;
import com.amazonaws.services.kinesisfirehose.model.UpdateDestinationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisFirehoseAsyncClient
extends AmazonKinesisFirehoseClient
implements AmazonKinesisFirehoseAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonKinesisFirehoseAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisFirehoseAsyncClientBuilder.standard();
    }

    AmazonKinesisFirehoseAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDeliveryStreamResult> createDeliveryStreamAsync(CreateDeliveryStreamRequest request) {
        return this.createDeliveryStreamAsync(request, null);
    }

    @Override
    public Future<CreateDeliveryStreamResult> createDeliveryStreamAsync(CreateDeliveryStreamRequest request, final AsyncHandler<CreateDeliveryStreamRequest, CreateDeliveryStreamResult> asyncHandler) {
        final CreateDeliveryStreamRequest finalRequest = (CreateDeliveryStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDeliveryStreamResult>(){

            @Override
            public CreateDeliveryStreamResult call() throws Exception {
                CreateDeliveryStreamResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executeCreateDeliveryStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeliveryStreamResult> deleteDeliveryStreamAsync(DeleteDeliveryStreamRequest request) {
        return this.deleteDeliveryStreamAsync(request, null);
    }

    @Override
    public Future<DeleteDeliveryStreamResult> deleteDeliveryStreamAsync(DeleteDeliveryStreamRequest request, final AsyncHandler<DeleteDeliveryStreamRequest, DeleteDeliveryStreamResult> asyncHandler) {
        final DeleteDeliveryStreamRequest finalRequest = (DeleteDeliveryStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDeliveryStreamResult>(){

            @Override
            public DeleteDeliveryStreamResult call() throws Exception {
                DeleteDeliveryStreamResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executeDeleteDeliveryStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryStreamResult> describeDeliveryStreamAsync(DescribeDeliveryStreamRequest request) {
        return this.describeDeliveryStreamAsync(request, null);
    }

    @Override
    public Future<DescribeDeliveryStreamResult> describeDeliveryStreamAsync(DescribeDeliveryStreamRequest request, final AsyncHandler<DescribeDeliveryStreamRequest, DescribeDeliveryStreamResult> asyncHandler) {
        final DescribeDeliveryStreamRequest finalRequest = (DescribeDeliveryStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeliveryStreamResult>(){

            @Override
            public DescribeDeliveryStreamResult call() throws Exception {
                DescribeDeliveryStreamResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executeDescribeDeliveryStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKinesisStreamResult> getKinesisStreamAsync(GetKinesisStreamRequest request) {
        return this.getKinesisStreamAsync(request, null);
    }

    @Override
    public Future<GetKinesisStreamResult> getKinesisStreamAsync(GetKinesisStreamRequest request, final AsyncHandler<GetKinesisStreamRequest, GetKinesisStreamResult> asyncHandler) {
        final GetKinesisStreamRequest finalRequest = (GetKinesisStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKinesisStreamResult>(){

            @Override
            public GetKinesisStreamResult call() throws Exception {
                GetKinesisStreamResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executeGetKinesisStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeliveryStreamsResult> listDeliveryStreamsAsync(ListDeliveryStreamsRequest request) {
        return this.listDeliveryStreamsAsync(request, null);
    }

    @Override
    public Future<ListDeliveryStreamsResult> listDeliveryStreamsAsync(ListDeliveryStreamsRequest request, final AsyncHandler<ListDeliveryStreamsRequest, ListDeliveryStreamsResult> asyncHandler) {
        final ListDeliveryStreamsRequest finalRequest = (ListDeliveryStreamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeliveryStreamsResult>(){

            @Override
            public ListDeliveryStreamsResult call() throws Exception {
                ListDeliveryStreamsResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executeListDeliveryStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(PutRecordRequest request) {
        return this.putRecordAsync(request, null);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(PutRecordRequest request, final AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        final PutRecordRequest finalRequest = (PutRecordRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRecordResult>(){

            @Override
            public PutRecordResult call() throws Exception {
                PutRecordResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executePutRecord(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordBatchResult> putRecordBatchAsync(PutRecordBatchRequest request) {
        return this.putRecordBatchAsync(request, null);
    }

    @Override
    public Future<PutRecordBatchResult> putRecordBatchAsync(PutRecordBatchRequest request, final AsyncHandler<PutRecordBatchRequest, PutRecordBatchResult> asyncHandler) {
        final PutRecordBatchRequest finalRequest = (PutRecordBatchRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRecordBatchResult>(){

            @Override
            public PutRecordBatchResult call() throws Exception {
                PutRecordBatchResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executePutRecordBatch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request) {
        return this.updateDestinationAsync(request, null);
    }

    @Override
    public Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request, final AsyncHandler<UpdateDestinationRequest, UpdateDestinationResult> asyncHandler) {
        final UpdateDestinationRequest finalRequest = (UpdateDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDestinationResult>(){

            @Override
            public UpdateDestinationResult call() throws Exception {
                UpdateDestinationResult result = null;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.executeUpdateDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

