/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.OutputDescription;
import com.amazonaws.services.kinesisanalytics.model.transform.DestinationSchemaJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseOutputDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsOutputDescriptionJsonMarshaller;

public class OutputDescriptionJsonMarshaller {
    private static OutputDescriptionJsonMarshaller instance;

    public void marshall(OutputDescription outputDescription, StructuredJsonGenerator jsonGenerator) {
        if (outputDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (outputDescription.getOutputId() != null) {
                jsonGenerator.writeFieldName("OutputId").writeValue(outputDescription.getOutputId());
            }
            if (outputDescription.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(outputDescription.getName());
            }
            if (outputDescription.getKinesisStreamsOutputDescription() != null) {
                jsonGenerator.writeFieldName("KinesisStreamsOutputDescription");
                KinesisStreamsOutputDescriptionJsonMarshaller.getInstance().marshall(outputDescription.getKinesisStreamsOutputDescription(), jsonGenerator);
            }
            if (outputDescription.getKinesisFirehoseOutputDescription() != null) {
                jsonGenerator.writeFieldName("KinesisFirehoseOutputDescription");
                KinesisFirehoseOutputDescriptionJsonMarshaller.getInstance().marshall(outputDescription.getKinesisFirehoseOutputDescription(), jsonGenerator);
            }
            if (outputDescription.getDestinationSchema() != null) {
                jsonGenerator.writeFieldName("DestinationSchema");
                DestinationSchemaJsonMarshaller.getInstance().marshall(outputDescription.getDestinationSchema(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OutputDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OutputDescriptionJsonMarshaller();
        }
        return instance;
    }
}

