/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesis.model.HashKeyRange;

@SdkInternalApi
public class HashKeyRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingHashKey").build();
    private static final MarshallingInfo<String> ENDINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingHashKey").build();
    private static final HashKeyRangeMarshaller instance = new HashKeyRangeMarshaller();

    public static HashKeyRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(HashKeyRange hashKeyRange, ProtocolMarshaller protocolMarshaller) {
        if (hashKeyRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hashKeyRange.getStartingHashKey(), STARTINGHASHKEY_BINDING);
            protocolMarshaller.marshall((Object)hashKeyRange.getEndingHashKey(), ENDINGHASHKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

