/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalytics.model.InputDescription;
import java.util.List;

@SdkInternalApi
public class InputDescriptionMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").build();
    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").build();
    private static final MarshallingInfo<List> INAPPSTREAMNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InAppStreamNames").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfigurationDescription").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInputDescription").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInputDescription").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelism").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSTARTINGPOSITIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputStartingPositionConfiguration").build();
    private static final InputDescriptionMarshaller instance = new InputDescriptionMarshaller();

    public static InputDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputDescription inputDescription, ProtocolMarshaller protocolMarshaller) {
        if (inputDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputDescription.getInputId(), INPUTID_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getNamePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall(inputDescription.getInAppStreamNames(), INAPPSTREAMNAMES_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getInputProcessingConfigurationDescription(), INPUTPROCESSINGCONFIGURATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getKinesisStreamsInputDescription(), KINESISSTREAMSINPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getKinesisFirehoseInputDescription(), KINESISFIREHOSEINPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getInputSchema(), INPUTSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getInputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall((Object)inputDescription.getInputStartingPositionConfiguration(), INPUTSTARTINGPOSITIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

