/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.ForwardValues;
import com.amazonaws.services.lightsail.model.HeaderEnum;
import com.amazonaws.services.lightsail.model.transform.HeaderObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HeaderObject
implements Serializable,
Cloneable,
StructuredPojo {
    private String option;
    private List<String> headersAllowList;

    public void setOption(String option) {
        this.option = option;
    }

    public String getOption() {
        return this.option;
    }

    public HeaderObject withOption(String option) {
        this.setOption(option);
        return this;
    }

    public HeaderObject withOption(ForwardValues option) {
        this.option = option.toString();
        return this;
    }

    public List<String> getHeadersAllowList() {
        return this.headersAllowList;
    }

    public void setHeadersAllowList(Collection<String> headersAllowList) {
        if (headersAllowList == null) {
            this.headersAllowList = null;
            return;
        }
        this.headersAllowList = new ArrayList<String>(headersAllowList);
    }

    public HeaderObject withHeadersAllowList(String ... headersAllowList) {
        if (this.headersAllowList == null) {
            this.setHeadersAllowList(new ArrayList<String>(headersAllowList.length));
        }
        for (String ele : headersAllowList) {
            this.headersAllowList.add(ele);
        }
        return this;
    }

    public HeaderObject withHeadersAllowList(Collection<String> headersAllowList) {
        this.setHeadersAllowList(headersAllowList);
        return this;
    }

    public HeaderObject withHeadersAllowList(HeaderEnum ... headersAllowList) {
        ArrayList<String> headersAllowListCopy = new ArrayList<String>(headersAllowList.length);
        for (HeaderEnum value : headersAllowList) {
            headersAllowListCopy.add(value.toString());
        }
        if (this.getHeadersAllowList() == null) {
            this.setHeadersAllowList(headersAllowListCopy);
        } else {
            this.getHeadersAllowList().addAll(headersAllowListCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOption() != null) {
            sb.append("Option: ").append(this.getOption()).append(",");
        }
        if (this.getHeadersAllowList() != null) {
            sb.append("HeadersAllowList: ").append(this.getHeadersAllowList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderObject)) {
            return false;
        }
        HeaderObject other = (HeaderObject)obj;
        if (other.getOption() == null ^ this.getOption() == null) {
            return false;
        }
        if (other.getOption() != null && !other.getOption().equals(this.getOption())) {
            return false;
        }
        if (other.getHeadersAllowList() == null ^ this.getHeadersAllowList() == null) {
            return false;
        }
        return other.getHeadersAllowList() == null || other.getHeadersAllowList().equals(this.getHeadersAllowList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOption() == null ? 0 : this.getOption().hashCode());
        hashCode = 31 * hashCode + (this.getHeadersAllowList() == null ? 0 : this.getHeadersAllowList().hashCode());
        return hashCode;
    }

    public HeaderObject clone() {
        try {
            return (HeaderObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HeaderObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

