/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.location.AmazonLocationAsync;
import com.amazonaws.services.location.AmazonLocationAsyncClientBuilder;
import com.amazonaws.services.location.AmazonLocationClient;
import com.amazonaws.services.location.model.AssociateTrackerConsumerRequest;
import com.amazonaws.services.location.model.AssociateTrackerConsumerResult;
import com.amazonaws.services.location.model.BatchDeleteDevicePositionHistoryRequest;
import com.amazonaws.services.location.model.BatchDeleteDevicePositionHistoryResult;
import com.amazonaws.services.location.model.BatchDeleteGeofenceRequest;
import com.amazonaws.services.location.model.BatchDeleteGeofenceResult;
import com.amazonaws.services.location.model.BatchEvaluateGeofencesRequest;
import com.amazonaws.services.location.model.BatchEvaluateGeofencesResult;
import com.amazonaws.services.location.model.BatchGetDevicePositionRequest;
import com.amazonaws.services.location.model.BatchGetDevicePositionResult;
import com.amazonaws.services.location.model.BatchPutGeofenceRequest;
import com.amazonaws.services.location.model.BatchPutGeofenceResult;
import com.amazonaws.services.location.model.BatchUpdateDevicePositionRequest;
import com.amazonaws.services.location.model.BatchUpdateDevicePositionResult;
import com.amazonaws.services.location.model.CalculateRouteRequest;
import com.amazonaws.services.location.model.CalculateRouteResult;
import com.amazonaws.services.location.model.CreateGeofenceCollectionRequest;
import com.amazonaws.services.location.model.CreateGeofenceCollectionResult;
import com.amazonaws.services.location.model.CreateMapRequest;
import com.amazonaws.services.location.model.CreateMapResult;
import com.amazonaws.services.location.model.CreatePlaceIndexRequest;
import com.amazonaws.services.location.model.CreatePlaceIndexResult;
import com.amazonaws.services.location.model.CreateRouteCalculatorRequest;
import com.amazonaws.services.location.model.CreateRouteCalculatorResult;
import com.amazonaws.services.location.model.CreateTrackerRequest;
import com.amazonaws.services.location.model.CreateTrackerResult;
import com.amazonaws.services.location.model.DeleteGeofenceCollectionRequest;
import com.amazonaws.services.location.model.DeleteGeofenceCollectionResult;
import com.amazonaws.services.location.model.DeleteMapRequest;
import com.amazonaws.services.location.model.DeleteMapResult;
import com.amazonaws.services.location.model.DeletePlaceIndexRequest;
import com.amazonaws.services.location.model.DeletePlaceIndexResult;
import com.amazonaws.services.location.model.DeleteRouteCalculatorRequest;
import com.amazonaws.services.location.model.DeleteRouteCalculatorResult;
import com.amazonaws.services.location.model.DeleteTrackerRequest;
import com.amazonaws.services.location.model.DeleteTrackerResult;
import com.amazonaws.services.location.model.DescribeGeofenceCollectionRequest;
import com.amazonaws.services.location.model.DescribeGeofenceCollectionResult;
import com.amazonaws.services.location.model.DescribeMapRequest;
import com.amazonaws.services.location.model.DescribeMapResult;
import com.amazonaws.services.location.model.DescribePlaceIndexRequest;
import com.amazonaws.services.location.model.DescribePlaceIndexResult;
import com.amazonaws.services.location.model.DescribeRouteCalculatorRequest;
import com.amazonaws.services.location.model.DescribeRouteCalculatorResult;
import com.amazonaws.services.location.model.DescribeTrackerRequest;
import com.amazonaws.services.location.model.DescribeTrackerResult;
import com.amazonaws.services.location.model.DisassociateTrackerConsumerRequest;
import com.amazonaws.services.location.model.DisassociateTrackerConsumerResult;
import com.amazonaws.services.location.model.GetDevicePositionHistoryRequest;
import com.amazonaws.services.location.model.GetDevicePositionHistoryResult;
import com.amazonaws.services.location.model.GetDevicePositionRequest;
import com.amazonaws.services.location.model.GetDevicePositionResult;
import com.amazonaws.services.location.model.GetGeofenceRequest;
import com.amazonaws.services.location.model.GetGeofenceResult;
import com.amazonaws.services.location.model.GetMapGlyphsRequest;
import com.amazonaws.services.location.model.GetMapGlyphsResult;
import com.amazonaws.services.location.model.GetMapSpritesRequest;
import com.amazonaws.services.location.model.GetMapSpritesResult;
import com.amazonaws.services.location.model.GetMapStyleDescriptorRequest;
import com.amazonaws.services.location.model.GetMapStyleDescriptorResult;
import com.amazonaws.services.location.model.GetMapTileRequest;
import com.amazonaws.services.location.model.GetMapTileResult;
import com.amazonaws.services.location.model.ListDevicePositionsRequest;
import com.amazonaws.services.location.model.ListDevicePositionsResult;
import com.amazonaws.services.location.model.ListGeofenceCollectionsRequest;
import com.amazonaws.services.location.model.ListGeofenceCollectionsResult;
import com.amazonaws.services.location.model.ListGeofencesRequest;
import com.amazonaws.services.location.model.ListGeofencesResult;
import com.amazonaws.services.location.model.ListMapsRequest;
import com.amazonaws.services.location.model.ListMapsResult;
import com.amazonaws.services.location.model.ListPlaceIndexesRequest;
import com.amazonaws.services.location.model.ListPlaceIndexesResult;
import com.amazonaws.services.location.model.ListRouteCalculatorsRequest;
import com.amazonaws.services.location.model.ListRouteCalculatorsResult;
import com.amazonaws.services.location.model.ListTagsForResourceRequest;
import com.amazonaws.services.location.model.ListTagsForResourceResult;
import com.amazonaws.services.location.model.ListTrackerConsumersRequest;
import com.amazonaws.services.location.model.ListTrackerConsumersResult;
import com.amazonaws.services.location.model.ListTrackersRequest;
import com.amazonaws.services.location.model.ListTrackersResult;
import com.amazonaws.services.location.model.PutGeofenceRequest;
import com.amazonaws.services.location.model.PutGeofenceResult;
import com.amazonaws.services.location.model.SearchPlaceIndexForPositionRequest;
import com.amazonaws.services.location.model.SearchPlaceIndexForPositionResult;
import com.amazonaws.services.location.model.SearchPlaceIndexForTextRequest;
import com.amazonaws.services.location.model.SearchPlaceIndexForTextResult;
import com.amazonaws.services.location.model.TagResourceRequest;
import com.amazonaws.services.location.model.TagResourceResult;
import com.amazonaws.services.location.model.UntagResourceRequest;
import com.amazonaws.services.location.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonLocationAsyncClient
extends AmazonLocationClient
implements AmazonLocationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonLocationAsyncClientBuilder asyncBuilder() {
        return AmazonLocationAsyncClientBuilder.standard();
    }

    AmazonLocationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonLocationAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateTrackerConsumerResult> associateTrackerConsumerAsync(AssociateTrackerConsumerRequest request) {
        return this.associateTrackerConsumerAsync(request, null);
    }

    @Override
    public Future<AssociateTrackerConsumerResult> associateTrackerConsumerAsync(AssociateTrackerConsumerRequest request, final AsyncHandler<AssociateTrackerConsumerRequest, AssociateTrackerConsumerResult> asyncHandler) {
        final AssociateTrackerConsumerRequest finalRequest = (AssociateTrackerConsumerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateTrackerConsumerResult>(){

            @Override
            public AssociateTrackerConsumerResult call() throws Exception {
                AssociateTrackerConsumerResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeAssociateTrackerConsumer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteDevicePositionHistoryResult> batchDeleteDevicePositionHistoryAsync(BatchDeleteDevicePositionHistoryRequest request) {
        return this.batchDeleteDevicePositionHistoryAsync(request, null);
    }

    @Override
    public Future<BatchDeleteDevicePositionHistoryResult> batchDeleteDevicePositionHistoryAsync(BatchDeleteDevicePositionHistoryRequest request, final AsyncHandler<BatchDeleteDevicePositionHistoryRequest, BatchDeleteDevicePositionHistoryResult> asyncHandler) {
        final BatchDeleteDevicePositionHistoryRequest finalRequest = (BatchDeleteDevicePositionHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteDevicePositionHistoryResult>(){

            @Override
            public BatchDeleteDevicePositionHistoryResult call() throws Exception {
                BatchDeleteDevicePositionHistoryResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeBatchDeleteDevicePositionHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteGeofenceResult> batchDeleteGeofenceAsync(BatchDeleteGeofenceRequest request) {
        return this.batchDeleteGeofenceAsync(request, null);
    }

    @Override
    public Future<BatchDeleteGeofenceResult> batchDeleteGeofenceAsync(BatchDeleteGeofenceRequest request, final AsyncHandler<BatchDeleteGeofenceRequest, BatchDeleteGeofenceResult> asyncHandler) {
        final BatchDeleteGeofenceRequest finalRequest = (BatchDeleteGeofenceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteGeofenceResult>(){

            @Override
            public BatchDeleteGeofenceResult call() throws Exception {
                BatchDeleteGeofenceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeBatchDeleteGeofence(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchEvaluateGeofencesResult> batchEvaluateGeofencesAsync(BatchEvaluateGeofencesRequest request) {
        return this.batchEvaluateGeofencesAsync(request, null);
    }

    @Override
    public Future<BatchEvaluateGeofencesResult> batchEvaluateGeofencesAsync(BatchEvaluateGeofencesRequest request, final AsyncHandler<BatchEvaluateGeofencesRequest, BatchEvaluateGeofencesResult> asyncHandler) {
        final BatchEvaluateGeofencesRequest finalRequest = (BatchEvaluateGeofencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchEvaluateGeofencesResult>(){

            @Override
            public BatchEvaluateGeofencesResult call() throws Exception {
                BatchEvaluateGeofencesResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeBatchEvaluateGeofences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetDevicePositionResult> batchGetDevicePositionAsync(BatchGetDevicePositionRequest request) {
        return this.batchGetDevicePositionAsync(request, null);
    }

    @Override
    public Future<BatchGetDevicePositionResult> batchGetDevicePositionAsync(BatchGetDevicePositionRequest request, final AsyncHandler<BatchGetDevicePositionRequest, BatchGetDevicePositionResult> asyncHandler) {
        final BatchGetDevicePositionRequest finalRequest = (BatchGetDevicePositionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetDevicePositionResult>(){

            @Override
            public BatchGetDevicePositionResult call() throws Exception {
                BatchGetDevicePositionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeBatchGetDevicePosition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchPutGeofenceResult> batchPutGeofenceAsync(BatchPutGeofenceRequest request) {
        return this.batchPutGeofenceAsync(request, null);
    }

    @Override
    public Future<BatchPutGeofenceResult> batchPutGeofenceAsync(BatchPutGeofenceRequest request, final AsyncHandler<BatchPutGeofenceRequest, BatchPutGeofenceResult> asyncHandler) {
        final BatchPutGeofenceRequest finalRequest = (BatchPutGeofenceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchPutGeofenceResult>(){

            @Override
            public BatchPutGeofenceResult call() throws Exception {
                BatchPutGeofenceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeBatchPutGeofence(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateDevicePositionResult> batchUpdateDevicePositionAsync(BatchUpdateDevicePositionRequest request) {
        return this.batchUpdateDevicePositionAsync(request, null);
    }

    @Override
    public Future<BatchUpdateDevicePositionResult> batchUpdateDevicePositionAsync(BatchUpdateDevicePositionRequest request, final AsyncHandler<BatchUpdateDevicePositionRequest, BatchUpdateDevicePositionResult> asyncHandler) {
        final BatchUpdateDevicePositionRequest finalRequest = (BatchUpdateDevicePositionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateDevicePositionResult>(){

            @Override
            public BatchUpdateDevicePositionResult call() throws Exception {
                BatchUpdateDevicePositionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeBatchUpdateDevicePosition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CalculateRouteResult> calculateRouteAsync(CalculateRouteRequest request) {
        return this.calculateRouteAsync(request, null);
    }

    @Override
    public Future<CalculateRouteResult> calculateRouteAsync(CalculateRouteRequest request, final AsyncHandler<CalculateRouteRequest, CalculateRouteResult> asyncHandler) {
        final CalculateRouteRequest finalRequest = (CalculateRouteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CalculateRouteResult>(){

            @Override
            public CalculateRouteResult call() throws Exception {
                CalculateRouteResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeCalculateRoute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGeofenceCollectionResult> createGeofenceCollectionAsync(CreateGeofenceCollectionRequest request) {
        return this.createGeofenceCollectionAsync(request, null);
    }

    @Override
    public Future<CreateGeofenceCollectionResult> createGeofenceCollectionAsync(CreateGeofenceCollectionRequest request, final AsyncHandler<CreateGeofenceCollectionRequest, CreateGeofenceCollectionResult> asyncHandler) {
        final CreateGeofenceCollectionRequest finalRequest = (CreateGeofenceCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGeofenceCollectionResult>(){

            @Override
            public CreateGeofenceCollectionResult call() throws Exception {
                CreateGeofenceCollectionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeCreateGeofenceCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMapResult> createMapAsync(CreateMapRequest request) {
        return this.createMapAsync(request, null);
    }

    @Override
    public Future<CreateMapResult> createMapAsync(CreateMapRequest request, final AsyncHandler<CreateMapRequest, CreateMapResult> asyncHandler) {
        final CreateMapRequest finalRequest = (CreateMapRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMapResult>(){

            @Override
            public CreateMapResult call() throws Exception {
                CreateMapResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeCreateMap(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePlaceIndexResult> createPlaceIndexAsync(CreatePlaceIndexRequest request) {
        return this.createPlaceIndexAsync(request, null);
    }

    @Override
    public Future<CreatePlaceIndexResult> createPlaceIndexAsync(CreatePlaceIndexRequest request, final AsyncHandler<CreatePlaceIndexRequest, CreatePlaceIndexResult> asyncHandler) {
        final CreatePlaceIndexRequest finalRequest = (CreatePlaceIndexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePlaceIndexResult>(){

            @Override
            public CreatePlaceIndexResult call() throws Exception {
                CreatePlaceIndexResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeCreatePlaceIndex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRouteCalculatorResult> createRouteCalculatorAsync(CreateRouteCalculatorRequest request) {
        return this.createRouteCalculatorAsync(request, null);
    }

    @Override
    public Future<CreateRouteCalculatorResult> createRouteCalculatorAsync(CreateRouteCalculatorRequest request, final AsyncHandler<CreateRouteCalculatorRequest, CreateRouteCalculatorResult> asyncHandler) {
        final CreateRouteCalculatorRequest finalRequest = (CreateRouteCalculatorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRouteCalculatorResult>(){

            @Override
            public CreateRouteCalculatorResult call() throws Exception {
                CreateRouteCalculatorResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeCreateRouteCalculator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrackerResult> createTrackerAsync(CreateTrackerRequest request) {
        return this.createTrackerAsync(request, null);
    }

    @Override
    public Future<CreateTrackerResult> createTrackerAsync(CreateTrackerRequest request, final AsyncHandler<CreateTrackerRequest, CreateTrackerResult> asyncHandler) {
        final CreateTrackerRequest finalRequest = (CreateTrackerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTrackerResult>(){

            @Override
            public CreateTrackerResult call() throws Exception {
                CreateTrackerResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeCreateTracker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGeofenceCollectionResult> deleteGeofenceCollectionAsync(DeleteGeofenceCollectionRequest request) {
        return this.deleteGeofenceCollectionAsync(request, null);
    }

    @Override
    public Future<DeleteGeofenceCollectionResult> deleteGeofenceCollectionAsync(DeleteGeofenceCollectionRequest request, final AsyncHandler<DeleteGeofenceCollectionRequest, DeleteGeofenceCollectionResult> asyncHandler) {
        final DeleteGeofenceCollectionRequest finalRequest = (DeleteGeofenceCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGeofenceCollectionResult>(){

            @Override
            public DeleteGeofenceCollectionResult call() throws Exception {
                DeleteGeofenceCollectionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDeleteGeofenceCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMapResult> deleteMapAsync(DeleteMapRequest request) {
        return this.deleteMapAsync(request, null);
    }

    @Override
    public Future<DeleteMapResult> deleteMapAsync(DeleteMapRequest request, final AsyncHandler<DeleteMapRequest, DeleteMapResult> asyncHandler) {
        final DeleteMapRequest finalRequest = (DeleteMapRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMapResult>(){

            @Override
            public DeleteMapResult call() throws Exception {
                DeleteMapResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDeleteMap(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePlaceIndexResult> deletePlaceIndexAsync(DeletePlaceIndexRequest request) {
        return this.deletePlaceIndexAsync(request, null);
    }

    @Override
    public Future<DeletePlaceIndexResult> deletePlaceIndexAsync(DeletePlaceIndexRequest request, final AsyncHandler<DeletePlaceIndexRequest, DeletePlaceIndexResult> asyncHandler) {
        final DeletePlaceIndexRequest finalRequest = (DeletePlaceIndexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePlaceIndexResult>(){

            @Override
            public DeletePlaceIndexResult call() throws Exception {
                DeletePlaceIndexResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDeletePlaceIndex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRouteCalculatorResult> deleteRouteCalculatorAsync(DeleteRouteCalculatorRequest request) {
        return this.deleteRouteCalculatorAsync(request, null);
    }

    @Override
    public Future<DeleteRouteCalculatorResult> deleteRouteCalculatorAsync(DeleteRouteCalculatorRequest request, final AsyncHandler<DeleteRouteCalculatorRequest, DeleteRouteCalculatorResult> asyncHandler) {
        final DeleteRouteCalculatorRequest finalRequest = (DeleteRouteCalculatorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRouteCalculatorResult>(){

            @Override
            public DeleteRouteCalculatorResult call() throws Exception {
                DeleteRouteCalculatorResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDeleteRouteCalculator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrackerResult> deleteTrackerAsync(DeleteTrackerRequest request) {
        return this.deleteTrackerAsync(request, null);
    }

    @Override
    public Future<DeleteTrackerResult> deleteTrackerAsync(DeleteTrackerRequest request, final AsyncHandler<DeleteTrackerRequest, DeleteTrackerResult> asyncHandler) {
        final DeleteTrackerRequest finalRequest = (DeleteTrackerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTrackerResult>(){

            @Override
            public DeleteTrackerResult call() throws Exception {
                DeleteTrackerResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDeleteTracker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGeofenceCollectionResult> describeGeofenceCollectionAsync(DescribeGeofenceCollectionRequest request) {
        return this.describeGeofenceCollectionAsync(request, null);
    }

    @Override
    public Future<DescribeGeofenceCollectionResult> describeGeofenceCollectionAsync(DescribeGeofenceCollectionRequest request, final AsyncHandler<DescribeGeofenceCollectionRequest, DescribeGeofenceCollectionResult> asyncHandler) {
        final DescribeGeofenceCollectionRequest finalRequest = (DescribeGeofenceCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGeofenceCollectionResult>(){

            @Override
            public DescribeGeofenceCollectionResult call() throws Exception {
                DescribeGeofenceCollectionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDescribeGeofenceCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMapResult> describeMapAsync(DescribeMapRequest request) {
        return this.describeMapAsync(request, null);
    }

    @Override
    public Future<DescribeMapResult> describeMapAsync(DescribeMapRequest request, final AsyncHandler<DescribeMapRequest, DescribeMapResult> asyncHandler) {
        final DescribeMapRequest finalRequest = (DescribeMapRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMapResult>(){

            @Override
            public DescribeMapResult call() throws Exception {
                DescribeMapResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDescribeMap(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePlaceIndexResult> describePlaceIndexAsync(DescribePlaceIndexRequest request) {
        return this.describePlaceIndexAsync(request, null);
    }

    @Override
    public Future<DescribePlaceIndexResult> describePlaceIndexAsync(DescribePlaceIndexRequest request, final AsyncHandler<DescribePlaceIndexRequest, DescribePlaceIndexResult> asyncHandler) {
        final DescribePlaceIndexRequest finalRequest = (DescribePlaceIndexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePlaceIndexResult>(){

            @Override
            public DescribePlaceIndexResult call() throws Exception {
                DescribePlaceIndexResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDescribePlaceIndex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRouteCalculatorResult> describeRouteCalculatorAsync(DescribeRouteCalculatorRequest request) {
        return this.describeRouteCalculatorAsync(request, null);
    }

    @Override
    public Future<DescribeRouteCalculatorResult> describeRouteCalculatorAsync(DescribeRouteCalculatorRequest request, final AsyncHandler<DescribeRouteCalculatorRequest, DescribeRouteCalculatorResult> asyncHandler) {
        final DescribeRouteCalculatorRequest finalRequest = (DescribeRouteCalculatorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRouteCalculatorResult>(){

            @Override
            public DescribeRouteCalculatorResult call() throws Exception {
                DescribeRouteCalculatorResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDescribeRouteCalculator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrackerResult> describeTrackerAsync(DescribeTrackerRequest request) {
        return this.describeTrackerAsync(request, null);
    }

    @Override
    public Future<DescribeTrackerResult> describeTrackerAsync(DescribeTrackerRequest request, final AsyncHandler<DescribeTrackerRequest, DescribeTrackerResult> asyncHandler) {
        final DescribeTrackerRequest finalRequest = (DescribeTrackerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrackerResult>(){

            @Override
            public DescribeTrackerResult call() throws Exception {
                DescribeTrackerResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDescribeTracker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateTrackerConsumerResult> disassociateTrackerConsumerAsync(DisassociateTrackerConsumerRequest request) {
        return this.disassociateTrackerConsumerAsync(request, null);
    }

    @Override
    public Future<DisassociateTrackerConsumerResult> disassociateTrackerConsumerAsync(DisassociateTrackerConsumerRequest request, final AsyncHandler<DisassociateTrackerConsumerRequest, DisassociateTrackerConsumerResult> asyncHandler) {
        final DisassociateTrackerConsumerRequest finalRequest = (DisassociateTrackerConsumerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateTrackerConsumerResult>(){

            @Override
            public DisassociateTrackerConsumerResult call() throws Exception {
                DisassociateTrackerConsumerResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeDisassociateTrackerConsumer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicePositionResult> getDevicePositionAsync(GetDevicePositionRequest request) {
        return this.getDevicePositionAsync(request, null);
    }

    @Override
    public Future<GetDevicePositionResult> getDevicePositionAsync(GetDevicePositionRequest request, final AsyncHandler<GetDevicePositionRequest, GetDevicePositionResult> asyncHandler) {
        final GetDevicePositionRequest finalRequest = (GetDevicePositionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDevicePositionResult>(){

            @Override
            public GetDevicePositionResult call() throws Exception {
                GetDevicePositionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetDevicePosition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicePositionHistoryResult> getDevicePositionHistoryAsync(GetDevicePositionHistoryRequest request) {
        return this.getDevicePositionHistoryAsync(request, null);
    }

    @Override
    public Future<GetDevicePositionHistoryResult> getDevicePositionHistoryAsync(GetDevicePositionHistoryRequest request, final AsyncHandler<GetDevicePositionHistoryRequest, GetDevicePositionHistoryResult> asyncHandler) {
        final GetDevicePositionHistoryRequest finalRequest = (GetDevicePositionHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDevicePositionHistoryResult>(){

            @Override
            public GetDevicePositionHistoryResult call() throws Exception {
                GetDevicePositionHistoryResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetDevicePositionHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGeofenceResult> getGeofenceAsync(GetGeofenceRequest request) {
        return this.getGeofenceAsync(request, null);
    }

    @Override
    public Future<GetGeofenceResult> getGeofenceAsync(GetGeofenceRequest request, final AsyncHandler<GetGeofenceRequest, GetGeofenceResult> asyncHandler) {
        final GetGeofenceRequest finalRequest = (GetGeofenceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGeofenceResult>(){

            @Override
            public GetGeofenceResult call() throws Exception {
                GetGeofenceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetGeofence(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMapGlyphsResult> getMapGlyphsAsync(GetMapGlyphsRequest request) {
        return this.getMapGlyphsAsync(request, null);
    }

    @Override
    public Future<GetMapGlyphsResult> getMapGlyphsAsync(GetMapGlyphsRequest request, final AsyncHandler<GetMapGlyphsRequest, GetMapGlyphsResult> asyncHandler) {
        final GetMapGlyphsRequest finalRequest = (GetMapGlyphsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMapGlyphsResult>(){

            @Override
            public GetMapGlyphsResult call() throws Exception {
                GetMapGlyphsResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetMapGlyphs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMapSpritesResult> getMapSpritesAsync(GetMapSpritesRequest request) {
        return this.getMapSpritesAsync(request, null);
    }

    @Override
    public Future<GetMapSpritesResult> getMapSpritesAsync(GetMapSpritesRequest request, final AsyncHandler<GetMapSpritesRequest, GetMapSpritesResult> asyncHandler) {
        final GetMapSpritesRequest finalRequest = (GetMapSpritesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMapSpritesResult>(){

            @Override
            public GetMapSpritesResult call() throws Exception {
                GetMapSpritesResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetMapSprites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMapStyleDescriptorResult> getMapStyleDescriptorAsync(GetMapStyleDescriptorRequest request) {
        return this.getMapStyleDescriptorAsync(request, null);
    }

    @Override
    public Future<GetMapStyleDescriptorResult> getMapStyleDescriptorAsync(GetMapStyleDescriptorRequest request, final AsyncHandler<GetMapStyleDescriptorRequest, GetMapStyleDescriptorResult> asyncHandler) {
        final GetMapStyleDescriptorRequest finalRequest = (GetMapStyleDescriptorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMapStyleDescriptorResult>(){

            @Override
            public GetMapStyleDescriptorResult call() throws Exception {
                GetMapStyleDescriptorResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetMapStyleDescriptor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMapTileResult> getMapTileAsync(GetMapTileRequest request) {
        return this.getMapTileAsync(request, null);
    }

    @Override
    public Future<GetMapTileResult> getMapTileAsync(GetMapTileRequest request, final AsyncHandler<GetMapTileRequest, GetMapTileResult> asyncHandler) {
        final GetMapTileRequest finalRequest = (GetMapTileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMapTileResult>(){

            @Override
            public GetMapTileResult call() throws Exception {
                GetMapTileResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeGetMapTile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicePositionsResult> listDevicePositionsAsync(ListDevicePositionsRequest request) {
        return this.listDevicePositionsAsync(request, null);
    }

    @Override
    public Future<ListDevicePositionsResult> listDevicePositionsAsync(ListDevicePositionsRequest request, final AsyncHandler<ListDevicePositionsRequest, ListDevicePositionsResult> asyncHandler) {
        final ListDevicePositionsRequest finalRequest = (ListDevicePositionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDevicePositionsResult>(){

            @Override
            public ListDevicePositionsResult call() throws Exception {
                ListDevicePositionsResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListDevicePositions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGeofenceCollectionsResult> listGeofenceCollectionsAsync(ListGeofenceCollectionsRequest request) {
        return this.listGeofenceCollectionsAsync(request, null);
    }

    @Override
    public Future<ListGeofenceCollectionsResult> listGeofenceCollectionsAsync(ListGeofenceCollectionsRequest request, final AsyncHandler<ListGeofenceCollectionsRequest, ListGeofenceCollectionsResult> asyncHandler) {
        final ListGeofenceCollectionsRequest finalRequest = (ListGeofenceCollectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGeofenceCollectionsResult>(){

            @Override
            public ListGeofenceCollectionsResult call() throws Exception {
                ListGeofenceCollectionsResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListGeofenceCollections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGeofencesResult> listGeofencesAsync(ListGeofencesRequest request) {
        return this.listGeofencesAsync(request, null);
    }

    @Override
    public Future<ListGeofencesResult> listGeofencesAsync(ListGeofencesRequest request, final AsyncHandler<ListGeofencesRequest, ListGeofencesResult> asyncHandler) {
        final ListGeofencesRequest finalRequest = (ListGeofencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGeofencesResult>(){

            @Override
            public ListGeofencesResult call() throws Exception {
                ListGeofencesResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListGeofences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMapsResult> listMapsAsync(ListMapsRequest request) {
        return this.listMapsAsync(request, null);
    }

    @Override
    public Future<ListMapsResult> listMapsAsync(ListMapsRequest request, final AsyncHandler<ListMapsRequest, ListMapsResult> asyncHandler) {
        final ListMapsRequest finalRequest = (ListMapsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMapsResult>(){

            @Override
            public ListMapsResult call() throws Exception {
                ListMapsResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListMaps(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlaceIndexesResult> listPlaceIndexesAsync(ListPlaceIndexesRequest request) {
        return this.listPlaceIndexesAsync(request, null);
    }

    @Override
    public Future<ListPlaceIndexesResult> listPlaceIndexesAsync(ListPlaceIndexesRequest request, final AsyncHandler<ListPlaceIndexesRequest, ListPlaceIndexesResult> asyncHandler) {
        final ListPlaceIndexesRequest finalRequest = (ListPlaceIndexesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPlaceIndexesResult>(){

            @Override
            public ListPlaceIndexesResult call() throws Exception {
                ListPlaceIndexesResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListPlaceIndexes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRouteCalculatorsResult> listRouteCalculatorsAsync(ListRouteCalculatorsRequest request) {
        return this.listRouteCalculatorsAsync(request, null);
    }

    @Override
    public Future<ListRouteCalculatorsResult> listRouteCalculatorsAsync(ListRouteCalculatorsRequest request, final AsyncHandler<ListRouteCalculatorsRequest, ListRouteCalculatorsResult> asyncHandler) {
        final ListRouteCalculatorsRequest finalRequest = (ListRouteCalculatorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRouteCalculatorsResult>(){

            @Override
            public ListRouteCalculatorsResult call() throws Exception {
                ListRouteCalculatorsResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListRouteCalculators(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrackerConsumersResult> listTrackerConsumersAsync(ListTrackerConsumersRequest request) {
        return this.listTrackerConsumersAsync(request, null);
    }

    @Override
    public Future<ListTrackerConsumersResult> listTrackerConsumersAsync(ListTrackerConsumersRequest request, final AsyncHandler<ListTrackerConsumersRequest, ListTrackerConsumersResult> asyncHandler) {
        final ListTrackerConsumersRequest finalRequest = (ListTrackerConsumersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTrackerConsumersResult>(){

            @Override
            public ListTrackerConsumersResult call() throws Exception {
                ListTrackerConsumersResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListTrackerConsumers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrackersResult> listTrackersAsync(ListTrackersRequest request) {
        return this.listTrackersAsync(request, null);
    }

    @Override
    public Future<ListTrackersResult> listTrackersAsync(ListTrackersRequest request, final AsyncHandler<ListTrackersRequest, ListTrackersResult> asyncHandler) {
        final ListTrackersRequest finalRequest = (ListTrackersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTrackersResult>(){

            @Override
            public ListTrackersResult call() throws Exception {
                ListTrackersResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeListTrackers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutGeofenceResult> putGeofenceAsync(PutGeofenceRequest request) {
        return this.putGeofenceAsync(request, null);
    }

    @Override
    public Future<PutGeofenceResult> putGeofenceAsync(PutGeofenceRequest request, final AsyncHandler<PutGeofenceRequest, PutGeofenceResult> asyncHandler) {
        final PutGeofenceRequest finalRequest = (PutGeofenceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutGeofenceResult>(){

            @Override
            public PutGeofenceResult call() throws Exception {
                PutGeofenceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executePutGeofence(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchPlaceIndexForPositionResult> searchPlaceIndexForPositionAsync(SearchPlaceIndexForPositionRequest request) {
        return this.searchPlaceIndexForPositionAsync(request, null);
    }

    @Override
    public Future<SearchPlaceIndexForPositionResult> searchPlaceIndexForPositionAsync(SearchPlaceIndexForPositionRequest request, final AsyncHandler<SearchPlaceIndexForPositionRequest, SearchPlaceIndexForPositionResult> asyncHandler) {
        final SearchPlaceIndexForPositionRequest finalRequest = (SearchPlaceIndexForPositionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchPlaceIndexForPositionResult>(){

            @Override
            public SearchPlaceIndexForPositionResult call() throws Exception {
                SearchPlaceIndexForPositionResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeSearchPlaceIndexForPosition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchPlaceIndexForTextResult> searchPlaceIndexForTextAsync(SearchPlaceIndexForTextRequest request) {
        return this.searchPlaceIndexForTextAsync(request, null);
    }

    @Override
    public Future<SearchPlaceIndexForTextResult> searchPlaceIndexForTextAsync(SearchPlaceIndexForTextRequest request, final AsyncHandler<SearchPlaceIndexForTextRequest, SearchPlaceIndexForTextResult> asyncHandler) {
        final SearchPlaceIndexForTextRequest finalRequest = (SearchPlaceIndexForTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchPlaceIndexForTextResult>(){

            @Override
            public SearchPlaceIndexForTextResult call() throws Exception {
                SearchPlaceIndexForTextResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeSearchPlaceIndexForText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonLocationAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

