/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.Cluster;
import java.util.List;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> PENDINGUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PendingUpdates").build();
    private static final MarshallingInfo<Integer> NUMBEROFSHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfShards").build();
    private static final MarshallingInfo<List> SHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shards").build();
    private static final MarshallingInfo<String> AVAILABILITYMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityMode").build();
    private static final MarshallingInfo<StructuredPojo> CLUSTERENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterEndpoint").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").build();
    private static final MarshallingInfo<String> ENGINEPATCHVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnginePatchVersion").build();
    private static final MarshallingInfo<String> PARAMETERGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupName").build();
    private static final MarshallingInfo<String> PARAMETERGROUPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupStatus").build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").build();
    private static final MarshallingInfo<String> SUBNETGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupName").build();
    private static final MarshallingInfo<Boolean> TLSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TLSEnabled").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ARN").build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicArn").build();
    private static final MarshallingInfo<String> SNSTOPICSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicStatus").build();
    private static final MarshallingInfo<Integer> SNAPSHOTRETENTIONLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotRetentionLimit").build();
    private static final MarshallingInfo<String> MAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaintenanceWindow").build();
    private static final MarshallingInfo<String> SNAPSHOTWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotWindow").build();
    private static final MarshallingInfo<String> ACLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ACLName").build();
    private static final MarshallingInfo<Boolean> AUTOMINORVERSIONUPGRADE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMinorVersionUpgrade").build();
    private static final ClusterMarshaller instance = new ClusterMarshaller();

    public static ClusterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        if (cluster == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cluster.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)cluster.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)cluster.getPendingUpdates(), PENDINGUPDATES_BINDING);
            protocolMarshaller.marshall((Object)cluster.getNumberOfShards(), NUMBEROFSHARDS_BINDING);
            protocolMarshaller.marshall(cluster.getShards(), SHARDS_BINDING);
            protocolMarshaller.marshall((Object)cluster.getAvailabilityMode(), AVAILABILITYMODE_BINDING);
            protocolMarshaller.marshall((Object)cluster.getClusterEndpoint(), CLUSTERENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)cluster.getNodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.getEngineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)cluster.getEnginePatchVersion(), ENGINEPATCHVERSION_BINDING);
            protocolMarshaller.marshall((Object)cluster.getParameterGroupName(), PARAMETERGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.getParameterGroupStatus(), PARAMETERGROUPSTATUS_BINDING);
            protocolMarshaller.marshall(cluster.getSecurityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSubnetGroupName(), SUBNETGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.getTLSEnabled(), TLSENABLED_BINDING);
            protocolMarshaller.marshall((Object)cluster.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)cluster.getARN(), ARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSnsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSnsTopicStatus(), SNSTOPICSTATUS_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSnapshotRetentionLimit(), SNAPSHOTRETENTIONLIMIT_BINDING);
            protocolMarshaller.marshall((Object)cluster.getMaintenanceWindow(), MAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)cluster.getSnapshotWindow(), SNAPSHOTWINDOW_BINDING);
            protocolMarshaller.marshall((Object)cluster.getACLName(), ACLNAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.getAutoMinorVersionUpgrade(), AUTOMINORVERSIONUPGRADE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

