/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.omics.AmazonOmics;
import com.amazonaws.services.omics.model.GetAnnotationImportJobRequest;
import com.amazonaws.services.omics.model.GetAnnotationStoreRequest;
import com.amazonaws.services.omics.model.GetReadSetActivationJobRequest;
import com.amazonaws.services.omics.model.GetReadSetExportJobRequest;
import com.amazonaws.services.omics.model.GetReadSetImportJobRequest;
import com.amazonaws.services.omics.model.GetReferenceImportJobRequest;
import com.amazonaws.services.omics.model.GetRunRequest;
import com.amazonaws.services.omics.model.GetRunTaskRequest;
import com.amazonaws.services.omics.model.GetVariantImportJobRequest;
import com.amazonaws.services.omics.model.GetVariantStoreRequest;
import com.amazonaws.services.omics.model.GetWorkflowRequest;
import com.amazonaws.services.omics.waiters.AnnotationImportJobCreated;
import com.amazonaws.services.omics.waiters.AnnotationStoreCreated;
import com.amazonaws.services.omics.waiters.AnnotationStoreDeleted;
import com.amazonaws.services.omics.waiters.GetAnnotationImportJobFunction;
import com.amazonaws.services.omics.waiters.GetAnnotationStoreFunction;
import com.amazonaws.services.omics.waiters.GetReadSetActivationJobFunction;
import com.amazonaws.services.omics.waiters.GetReadSetExportJobFunction;
import com.amazonaws.services.omics.waiters.GetReadSetImportJobFunction;
import com.amazonaws.services.omics.waiters.GetReferenceImportJobFunction;
import com.amazonaws.services.omics.waiters.GetRunFunction;
import com.amazonaws.services.omics.waiters.GetRunTaskFunction;
import com.amazonaws.services.omics.waiters.GetVariantImportJobFunction;
import com.amazonaws.services.omics.waiters.GetVariantStoreFunction;
import com.amazonaws.services.omics.waiters.GetWorkflowFunction;
import com.amazonaws.services.omics.waiters.ReadSetActivationJobCompleted;
import com.amazonaws.services.omics.waiters.ReadSetExportJobCompleted;
import com.amazonaws.services.omics.waiters.ReadSetImportJobCompleted;
import com.amazonaws.services.omics.waiters.ReferenceImportJobCompleted;
import com.amazonaws.services.omics.waiters.RunCompleted;
import com.amazonaws.services.omics.waiters.RunRunning;
import com.amazonaws.services.omics.waiters.TaskCompleted;
import com.amazonaws.services.omics.waiters.TaskRunning;
import com.amazonaws.services.omics.waiters.VariantImportJobCreated;
import com.amazonaws.services.omics.waiters.VariantStoreCreated;
import com.amazonaws.services.omics.waiters.VariantStoreDeleted;
import com.amazonaws.services.omics.waiters.WorkflowActive;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonOmicsWaiters {
    private final AmazonOmics client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonOmicsWaiters");

    @SdkInternalApi
    public AmazonOmicsWaiters(AmazonOmics client) {
        this.client = client;
    }

    public Waiter<GetRunRequest> runRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetRunFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new RunRunning.IsRUNNINGMatcher(), new RunRunning.IsPENDINGMatcher(), new RunRunning.IsSTARTINGMatcher(), new RunRunning.IsFAILEDMatcher(), new RunRunning.IsCANCELLEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetReadSetImportJobRequest> readSetImportJobCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetReadSetImportJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReadSetImportJobCompleted.IsCOMPLETEDMatcher(), new ReadSetImportJobCompleted.IsSUBMITTEDMatcher(), new ReadSetImportJobCompleted.IsIN_PROGRESSMatcher(), new ReadSetImportJobCompleted.IsCANCELLINGMatcher(), new ReadSetImportJobCompleted.IsCANCELLEDMatcher(), new ReadSetImportJobCompleted.IsFAILEDMatcher(), new ReadSetImportJobCompleted.IsCOMPLETED_WITH_FAILURESMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetAnnotationStoreRequest> annotationStoreDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetAnnotationStoreFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AnnotationStoreDeleted.IsDELETEDMatcher(), new AnnotationStoreDeleted.IsResourceNotFoundExceptionMatcher(), new AnnotationStoreDeleted.IsDELETINGMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetWorkflowRequest> workflowActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetWorkflowFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new WorkflowActive.IsACTIVEMatcher(), new WorkflowActive.IsCREATINGMatcher(), new WorkflowActive.IsUPDATINGMatcher(), new WorkflowActive.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(10), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetAnnotationImportJobRequest> annotationImportJobCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetAnnotationImportJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AnnotationImportJobCreated.IsSUBMITTEDMatcher(), new AnnotationImportJobCreated.IsIN_PROGRESSMatcher(), new AnnotationImportJobCreated.IsFAILEDMatcher(), new AnnotationImportJobCreated.IsCANCELLEDMatcher(), new AnnotationImportJobCreated.IsCOMPLETEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetRunTaskRequest> taskCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetRunTaskFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TaskCompleted.IsCOMPLETEDMatcher(), new TaskCompleted.IsPENDINGMatcher(), new TaskCompleted.IsSTARTINGMatcher(), new TaskCompleted.IsRUNNINGMatcher(), new TaskCompleted.IsSTOPPINGMatcher(), new TaskCompleted.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetReadSetActivationJobRequest> readSetActivationJobCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetReadSetActivationJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReadSetActivationJobCompleted.IsCOMPLETEDMatcher(), new ReadSetActivationJobCompleted.IsSUBMITTEDMatcher(), new ReadSetActivationJobCompleted.IsIN_PROGRESSMatcher(), new ReadSetActivationJobCompleted.IsCANCELLINGMatcher(), new ReadSetActivationJobCompleted.IsCANCELLEDMatcher(), new ReadSetActivationJobCompleted.IsFAILEDMatcher(), new ReadSetActivationJobCompleted.IsCOMPLETED_WITH_FAILURESMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetReadSetExportJobRequest> readSetExportJobCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetReadSetExportJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReadSetExportJobCompleted.IsCOMPLETEDMatcher(), new ReadSetExportJobCompleted.IsSUBMITTEDMatcher(), new ReadSetExportJobCompleted.IsIN_PROGRESSMatcher(), new ReadSetExportJobCompleted.IsCANCELLINGMatcher(), new ReadSetExportJobCompleted.IsCANCELLEDMatcher(), new ReadSetExportJobCompleted.IsFAILEDMatcher(), new ReadSetExportJobCompleted.IsCOMPLETED_WITH_FAILURESMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetRunRequest> runCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetRunFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new RunCompleted.IsCOMPLETEDMatcher(), new RunCompleted.IsPENDINGMatcher(), new RunCompleted.IsSTARTINGMatcher(), new RunCompleted.IsRUNNINGMatcher(), new RunCompleted.IsSTOPPINGMatcher(), new RunCompleted.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetAnnotationStoreRequest> annotationStoreCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetAnnotationStoreFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AnnotationStoreCreated.IsACTIVEMatcher(), new AnnotationStoreCreated.IsCREATINGMatcher(), new AnnotationStoreCreated.IsUPDATINGMatcher(), new AnnotationStoreCreated.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetVariantImportJobRequest> variantImportJobCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetVariantImportJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VariantImportJobCreated.IsSUBMITTEDMatcher(), new VariantImportJobCreated.IsIN_PROGRESSMatcher(), new VariantImportJobCreated.IsFAILEDMatcher(), new VariantImportJobCreated.IsCANCELLEDMatcher(), new VariantImportJobCreated.IsCOMPLETEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetVariantStoreRequest> variantStoreDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetVariantStoreFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VariantStoreDeleted.IsDELETEDMatcher(), new VariantStoreDeleted.IsResourceNotFoundExceptionMatcher(), new VariantStoreDeleted.IsDELETINGMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetReferenceImportJobRequest> referenceImportJobCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetReferenceImportJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReferenceImportJobCompleted.IsCOMPLETEDMatcher(), new ReferenceImportJobCompleted.IsSUBMITTEDMatcher(), new ReferenceImportJobCompleted.IsIN_PROGRESSMatcher(), new ReferenceImportJobCompleted.IsCANCELLINGMatcher(), new ReferenceImportJobCompleted.IsCANCELLEDMatcher(), new ReferenceImportJobCompleted.IsFAILEDMatcher(), new ReferenceImportJobCompleted.IsCOMPLETED_WITH_FAILURESMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetVariantStoreRequest> variantStoreCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetVariantStoreFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VariantStoreCreated.IsACTIVEMatcher(), new VariantStoreCreated.IsCREATINGMatcher(), new VariantStoreCreated.IsUPDATINGMatcher(), new VariantStoreCreated.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetRunTaskRequest> taskRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetRunTaskFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TaskRunning.IsRUNNINGMatcher(), new TaskRunning.IsPENDINGMatcher(), new TaskRunning.IsSTARTINGMatcher(), new TaskRunning.IsFAILEDMatcher(), new TaskRunning.IsCANCELLEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

