/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.omics.model.ReferenceItem;
import com.amazonaws.services.omics.model.SseConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateVariantStoreRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ReferenceItem reference;
    private String name;
    private String description;
    private Map<String, String> tags;
    private SseConfig sseConfig;

    public void setReference(ReferenceItem reference) {
        this.reference = reference;
    }

    public ReferenceItem getReference() {
        return this.reference;
    }

    public CreateVariantStoreRequest withReference(ReferenceItem reference) {
        this.setReference(reference);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateVariantStoreRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateVariantStoreRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateVariantStoreRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateVariantStoreRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateVariantStoreRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setSseConfig(SseConfig sseConfig) {
        this.sseConfig = sseConfig;
    }

    public SseConfig getSseConfig() {
        return this.sseConfig;
    }

    public CreateVariantStoreRequest withSseConfig(SseConfig sseConfig) {
        this.setSseConfig(sseConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReference() != null) {
            sb.append("Reference: ").append(this.getReference()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSseConfig() != null) {
            sb.append("SseConfig: ").append(this.getSseConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVariantStoreRequest)) {
            return false;
        }
        CreateVariantStoreRequest other = (CreateVariantStoreRequest)obj;
        if (other.getReference() == null ^ this.getReference() == null) {
            return false;
        }
        if (other.getReference() != null && !other.getReference().equals(this.getReference())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSseConfig() == null ^ this.getSseConfig() == null) {
            return false;
        }
        return other.getSseConfig() == null || other.getSseConfig().equals(this.getSseConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReference() == null ? 0 : this.getReference().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSseConfig() == null ? 0 : this.getSseConfig().hashCode());
        return hashCode;
    }

    public CreateVariantStoreRequest clone() {
        return (CreateVariantStoreRequest)super.clone();
    }
}

