/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.omics.model.ETag;

@SdkInternalApi
public class ETagMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").build();
    private static final MarshallingInfo<String> SOURCE1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source1").build();
    private static final MarshallingInfo<String> SOURCE2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source2").build();
    private static final ETagMarshaller instance = new ETagMarshaller();

    public static ETagMarshaller getInstance() {
        return instance;
    }

    public void marshall(ETag eTag, ProtocolMarshaller protocolMarshaller) {
        if (eTag == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eTag.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)eTag.getSource1(), SOURCE1_BINDING);
            protocolMarshaller.marshall((Object)eTag.getSource2(), SOURCE2_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

