/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53.model.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.route53.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListTrafficPoliciesResult StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListTrafficPoliciesResultStaxUnmarshaller implements Unmarshaller<ListTrafficPoliciesResult, StaxUnmarshallerContext> {

    public ListTrafficPoliciesResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListTrafficPoliciesResult listTrafficPoliciesResult = new ListTrafficPoliciesResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return listTrafficPoliciesResult;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("TrafficPolicySummaries", targetDepth)) {
                    listTrafficPoliciesResult.withTrafficPolicySummaries(new ArrayList<TrafficPolicySummary>());
                    continue;
                }

                if (context.testExpression("TrafficPolicySummaries/TrafficPolicySummary", targetDepth)) {
                    listTrafficPoliciesResult.withTrafficPolicySummaries(TrafficPolicySummaryStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listTrafficPoliciesResult.setIsTruncated(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrafficPolicyIdMarker", targetDepth)) {
                    listTrafficPoliciesResult.setTrafficPolicyIdMarker(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listTrafficPoliciesResult.setMaxItems(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return listTrafficPoliciesResult;
                }
            }
        }
    }

    private static ListTrafficPoliciesResultStaxUnmarshaller instance;

    public static ListTrafficPoliciesResultStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ListTrafficPoliciesResultStaxUnmarshaller();
        return instance;
    }
}
