/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apigateway.model.PatchOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateModelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String restApiId;
    private String modelName;
    private List<PatchOperation> patchOperations;

    public void setRestApiId(String restApiId) {
        this.restApiId = restApiId;
    }

    public String getRestApiId() {
        return this.restApiId;
    }

    public UpdateModelRequest withRestApiId(String restApiId) {
        this.setRestApiId(restApiId);
        return this;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public UpdateModelRequest withModelName(String modelName) {
        this.setModelName(modelName);
        return this;
    }

    public List<PatchOperation> getPatchOperations() {
        return this.patchOperations;
    }

    public void setPatchOperations(Collection<PatchOperation> patchOperations) {
        if (patchOperations == null) {
            this.patchOperations = null;
            return;
        }
        this.patchOperations = new ArrayList<PatchOperation>(patchOperations);
    }

    public UpdateModelRequest withPatchOperations(PatchOperation ... patchOperations) {
        if (this.patchOperations == null) {
            this.setPatchOperations(new ArrayList<PatchOperation>(patchOperations.length));
        }
        for (PatchOperation ele : patchOperations) {
            this.patchOperations.add(ele);
        }
        return this;
    }

    public UpdateModelRequest withPatchOperations(Collection<PatchOperation> patchOperations) {
        this.setPatchOperations(patchOperations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRestApiId() != null) {
            sb.append("RestApiId: ").append(this.getRestApiId()).append(",");
        }
        if (this.getModelName() != null) {
            sb.append("ModelName: ").append(this.getModelName()).append(",");
        }
        if (this.getPatchOperations() != null) {
            sb.append("PatchOperations: ").append(this.getPatchOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelRequest)) {
            return false;
        }
        UpdateModelRequest other = (UpdateModelRequest)obj;
        if (other.getRestApiId() == null ^ this.getRestApiId() == null) {
            return false;
        }
        if (other.getRestApiId() != null && !other.getRestApiId().equals(this.getRestApiId())) {
            return false;
        }
        if (other.getModelName() == null ^ this.getModelName() == null) {
            return false;
        }
        if (other.getModelName() != null && !other.getModelName().equals(this.getModelName())) {
            return false;
        }
        if (other.getPatchOperations() == null ^ this.getPatchOperations() == null) {
            return false;
        }
        return other.getPatchOperations() == null || other.getPatchOperations().equals(this.getPatchOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRestApiId() == null ? 0 : this.getRestApiId().hashCode());
        hashCode = 31 * hashCode + (this.getModelName() == null ? 0 : this.getModelName().hashCode());
        hashCode = 31 * hashCode + (this.getPatchOperations() == null ? 0 : this.getPatchOperations().hashCode());
        return hashCode;
    }

    @Override
    public UpdateModelRequest clone() {
        return (UpdateModelRequest)super.clone();
    }
}

