/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AttachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<AttachLoadBalancerTargetGroupsRequest>, AttachLoadBalancerTargetGroupsRequest> {
    @Override
    public Request<AttachLoadBalancerTargetGroupsRequest> marshall(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        SdkInternalList targetGroupARNsList;
        if (attachLoadBalancerTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AttachLoadBalancerTargetGroupsRequest> request = new DefaultRequest<AttachLoadBalancerTargetGroupsRequest>(attachLoadBalancerTargetGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "AttachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(attachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName()));
        }
        if (!(targetGroupARNsList = (SdkInternalList)attachLoadBalancerTargetGroupsRequest.getTargetGroupARNs()).isEmpty() || !targetGroupARNsList.isAutoConstruct()) {
            int targetGroupARNsListIndex = 1;
            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringUtils.fromString(targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        return request;
    }
}

