/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.SchemaFacet;
import com.amazonaws.services.clouddirectory.model.transform.BatchAddFacetToObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchAddFacetToObject
implements Serializable,
Cloneable,
StructuredPojo {
    private SchemaFacet schemaFacet;
    private List<AttributeKeyAndValue> objectAttributeList;
    private ObjectReference objectReference;

    public void setSchemaFacet(SchemaFacet schemaFacet) {
        this.schemaFacet = schemaFacet;
    }

    public SchemaFacet getSchemaFacet() {
        return this.schemaFacet;
    }

    public BatchAddFacetToObject withSchemaFacet(SchemaFacet schemaFacet) {
        this.setSchemaFacet(schemaFacet);
        return this;
    }

    public List<AttributeKeyAndValue> getObjectAttributeList() {
        return this.objectAttributeList;
    }

    public void setObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
        if (objectAttributeList == null) {
            this.objectAttributeList = null;
            return;
        }
        this.objectAttributeList = new ArrayList<AttributeKeyAndValue>(objectAttributeList);
    }

    public BatchAddFacetToObject withObjectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
        if (this.objectAttributeList == null) {
            this.setObjectAttributeList(new ArrayList<AttributeKeyAndValue>(objectAttributeList.length));
        }
        for (AttributeKeyAndValue ele : objectAttributeList) {
            this.objectAttributeList.add(ele);
        }
        return this;
    }

    public BatchAddFacetToObject withObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
        this.setObjectAttributeList(objectAttributeList);
        return this;
    }

    public void setObjectReference(ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    public BatchAddFacetToObject withObjectReference(ObjectReference objectReference) {
        this.setObjectReference(objectReference);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSchemaFacet() != null) {
            sb.append("SchemaFacet: ").append(this.getSchemaFacet()).append(",");
        }
        if (this.getObjectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.getObjectAttributeList()).append(",");
        }
        if (this.getObjectReference() != null) {
            sb.append("ObjectReference: ").append(this.getObjectReference());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddFacetToObject)) {
            return false;
        }
        BatchAddFacetToObject other = (BatchAddFacetToObject)obj;
        if (other.getSchemaFacet() == null ^ this.getSchemaFacet() == null) {
            return false;
        }
        if (other.getSchemaFacet() != null && !other.getSchemaFacet().equals(this.getSchemaFacet())) {
            return false;
        }
        if (other.getObjectAttributeList() == null ^ this.getObjectAttributeList() == null) {
            return false;
        }
        if (other.getObjectAttributeList() != null && !other.getObjectAttributeList().equals(this.getObjectAttributeList())) {
            return false;
        }
        if (other.getObjectReference() == null ^ this.getObjectReference() == null) {
            return false;
        }
        return other.getObjectReference() == null || other.getObjectReference().equals(this.getObjectReference());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSchemaFacet() == null ? 0 : this.getSchemaFacet().hashCode());
        hashCode = 31 * hashCode + (this.getObjectAttributeList() == null ? 0 : this.getObjectAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.getObjectReference() == null ? 0 : this.getObjectReference().hashCode());
        return hashCode;
    }

    public BatchAddFacetToObject clone() {
        try {
            return (BatchAddFacetToObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchAddFacetToObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

