/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsAsync;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsAsyncClientBuilder;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClient;
import com.amazonaws.services.cloudwatchevents.model.DeleteRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DeleteRuleResult;
import com.amazonaws.services.cloudwatchevents.model.DescribeEventBusRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeEventBusResult;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleResult;
import com.amazonaws.services.cloudwatchevents.model.DisableRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DisableRuleResult;
import com.amazonaws.services.cloudwatchevents.model.EnableRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.EnableRuleResult;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetResult;
import com.amazonaws.services.cloudwatchevents.model.ListRulesRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRulesResult;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutEventsResult;
import com.amazonaws.services.cloudwatchevents.model.PutPermissionRequest;
import com.amazonaws.services.cloudwatchevents.model.PutPermissionResult;
import com.amazonaws.services.cloudwatchevents.model.PutRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.PutRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsResult;
import com.amazonaws.services.cloudwatchevents.model.RemovePermissionRequest;
import com.amazonaws.services.cloudwatchevents.model.RemovePermissionResult;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsResult;
import com.amazonaws.services.cloudwatchevents.model.TestEventPatternRequest;
import com.amazonaws.services.cloudwatchevents.model.TestEventPatternResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudWatchEventsAsyncClient
extends AmazonCloudWatchEventsClient
implements AmazonCloudWatchEventsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCloudWatchEventsAsyncClientBuilder asyncBuilder() {
        return AmazonCloudWatchEventsAsyncClientBuilder.standard();
    }

    AmazonCloudWatchEventsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request) {
        return this.deleteRuleAsync(request, null);
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request, final AsyncHandler<DeleteRuleRequest, DeleteRuleResult> asyncHandler) {
        final DeleteRuleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRuleResult>(){

            @Override
            public DeleteRuleResult call() throws Exception {
                DeleteRuleResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeDeleteRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventBusResult> describeEventBusAsync(DescribeEventBusRequest request) {
        return this.describeEventBusAsync(request, null);
    }

    @Override
    public Future<DescribeEventBusResult> describeEventBusAsync(DescribeEventBusRequest request, final AsyncHandler<DescribeEventBusRequest, DescribeEventBusResult> asyncHandler) {
        final DescribeEventBusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventBusResult>(){

            @Override
            public DescribeEventBusResult call() throws Exception {
                DescribeEventBusResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeDescribeEventBus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRuleResult> describeRuleAsync(DescribeRuleRequest request) {
        return this.describeRuleAsync(request, null);
    }

    @Override
    public Future<DescribeRuleResult> describeRuleAsync(DescribeRuleRequest request, final AsyncHandler<DescribeRuleRequest, DescribeRuleResult> asyncHandler) {
        final DescribeRuleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRuleResult>(){

            @Override
            public DescribeRuleResult call() throws Exception {
                DescribeRuleResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeDescribeRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableRuleResult> disableRuleAsync(DisableRuleRequest request) {
        return this.disableRuleAsync(request, null);
    }

    @Override
    public Future<DisableRuleResult> disableRuleAsync(DisableRuleRequest request, final AsyncHandler<DisableRuleRequest, DisableRuleResult> asyncHandler) {
        final DisableRuleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableRuleResult>(){

            @Override
            public DisableRuleResult call() throws Exception {
                DisableRuleResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeDisableRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableRuleResult> enableRuleAsync(EnableRuleRequest request) {
        return this.enableRuleAsync(request, null);
    }

    @Override
    public Future<EnableRuleResult> enableRuleAsync(EnableRuleRequest request, final AsyncHandler<EnableRuleRequest, EnableRuleResult> asyncHandler) {
        final EnableRuleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableRuleResult>(){

            @Override
            public EnableRuleResult call() throws Exception {
                EnableRuleResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeEnableRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRuleNamesByTargetResult> listRuleNamesByTargetAsync(ListRuleNamesByTargetRequest request) {
        return this.listRuleNamesByTargetAsync(request, null);
    }

    @Override
    public Future<ListRuleNamesByTargetResult> listRuleNamesByTargetAsync(ListRuleNamesByTargetRequest request, final AsyncHandler<ListRuleNamesByTargetRequest, ListRuleNamesByTargetResult> asyncHandler) {
        final ListRuleNamesByTargetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRuleNamesByTargetResult>(){

            @Override
            public ListRuleNamesByTargetResult call() throws Exception {
                ListRuleNamesByTargetResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeListRuleNamesByTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request) {
        return this.listRulesAsync(request, null);
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request, final AsyncHandler<ListRulesRequest, ListRulesResult> asyncHandler) {
        final ListRulesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRulesResult>(){

            @Override
            public ListRulesResult call() throws Exception {
                ListRulesResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeListRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetsByRuleResult> listTargetsByRuleAsync(ListTargetsByRuleRequest request) {
        return this.listTargetsByRuleAsync(request, null);
    }

    @Override
    public Future<ListTargetsByRuleResult> listTargetsByRuleAsync(ListTargetsByRuleRequest request, final AsyncHandler<ListTargetsByRuleRequest, ListTargetsByRuleResult> asyncHandler) {
        final ListTargetsByRuleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTargetsByRuleResult>(){

            @Override
            public ListTargetsByRuleResult call() throws Exception {
                ListTargetsByRuleResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeListTargetsByRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request) {
        return this.putEventsAsync(request, null);
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request, final AsyncHandler<PutEventsRequest, PutEventsResult> asyncHandler) {
        final PutEventsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEventsResult>(){

            @Override
            public PutEventsResult call() throws Exception {
                PutEventsResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executePutEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPermissionResult> putPermissionAsync(PutPermissionRequest request) {
        return this.putPermissionAsync(request, null);
    }

    @Override
    public Future<PutPermissionResult> putPermissionAsync(PutPermissionRequest request, final AsyncHandler<PutPermissionRequest, PutPermissionResult> asyncHandler) {
        final PutPermissionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPermissionResult>(){

            @Override
            public PutPermissionResult call() throws Exception {
                PutPermissionResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executePutPermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRuleResult> putRuleAsync(PutRuleRequest request) {
        return this.putRuleAsync(request, null);
    }

    @Override
    public Future<PutRuleResult> putRuleAsync(PutRuleRequest request, final AsyncHandler<PutRuleRequest, PutRuleResult> asyncHandler) {
        final PutRuleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRuleResult>(){

            @Override
            public PutRuleResult call() throws Exception {
                PutRuleResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executePutRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTargetsResult> putTargetsAsync(PutTargetsRequest request) {
        return this.putTargetsAsync(request, null);
    }

    @Override
    public Future<PutTargetsResult> putTargetsAsync(PutTargetsRequest request, final AsyncHandler<PutTargetsRequest, PutTargetsResult> asyncHandler) {
        final PutTargetsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTargetsResult>(){

            @Override
            public PutTargetsResult call() throws Exception {
                PutTargetsResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executePutTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request) {
        return this.removePermissionAsync(request, null);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request, final AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        final RemovePermissionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemovePermissionResult>(){

            @Override
            public RemovePermissionResult call() throws Exception {
                RemovePermissionResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeRemovePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTargetsResult> removeTargetsAsync(RemoveTargetsRequest request) {
        return this.removeTargetsAsync(request, null);
    }

    @Override
    public Future<RemoveTargetsResult> removeTargetsAsync(RemoveTargetsRequest request, final AsyncHandler<RemoveTargetsRequest, RemoveTargetsResult> asyncHandler) {
        final RemoveTargetsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTargetsResult>(){

            @Override
            public RemoveTargetsResult call() throws Exception {
                RemoveTargetsResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeRemoveTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestEventPatternResult> testEventPatternAsync(TestEventPatternRequest request) {
        return this.testEventPatternAsync(request, null);
    }

    @Override
    public Future<TestEventPatternResult> testEventPatternAsync(TestEventPatternRequest request, final AsyncHandler<TestEventPatternRequest, TestEventPatternResult> asyncHandler) {
        final TestEventPatternRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestEventPatternResult>(){

            @Override
            public TestEventPatternResult call() throws Exception {
                TestEventPatternResult result = null;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.executeTestEventPattern(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

