/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.RepositoryTriggerEventEnum;
import com.amazonaws.services.codecommit.model.transform.RepositoryTriggerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepositoryTrigger
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String destinationArn;
    private String customData;
    private List<String> branches;
    private List<String> events;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RepositoryTrigger withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDestinationArn(String destinationArn) {
        this.destinationArn = destinationArn;
    }

    public String getDestinationArn() {
        return this.destinationArn;
    }

    public RepositoryTrigger withDestinationArn(String destinationArn) {
        this.setDestinationArn(destinationArn);
        return this;
    }

    public void setCustomData(String customData) {
        this.customData = customData;
    }

    public String getCustomData() {
        return this.customData;
    }

    public RepositoryTrigger withCustomData(String customData) {
        this.setCustomData(customData);
        return this;
    }

    public List<String> getBranches() {
        return this.branches;
    }

    public void setBranches(Collection<String> branches) {
        if (branches == null) {
            this.branches = null;
            return;
        }
        this.branches = new ArrayList<String>(branches);
    }

    public RepositoryTrigger withBranches(String ... branches) {
        if (this.branches == null) {
            this.setBranches(new ArrayList<String>(branches.length));
        }
        for (String ele : branches) {
            this.branches.add(ele);
        }
        return this;
    }

    public RepositoryTrigger withBranches(Collection<String> branches) {
        this.setBranches(branches);
        return this;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<String>(events);
    }

    public RepositoryTrigger withEvents(String ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<String>(events.length));
        }
        for (String ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public RepositoryTrigger withEvents(Collection<String> events) {
        this.setEvents(events);
        return this;
    }

    public RepositoryTrigger withEvents(RepositoryTriggerEventEnum ... events) {
        ArrayList<String> eventsCopy = new ArrayList<String>(events.length);
        for (RepositoryTriggerEventEnum value : events) {
            eventsCopy.add(value.toString());
        }
        if (this.getEvents() == null) {
            this.setEvents(eventsCopy);
        } else {
            this.getEvents().addAll(eventsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDestinationArn() != null) {
            sb.append("DestinationArn: ").append(this.getDestinationArn()).append(",");
        }
        if (this.getCustomData() != null) {
            sb.append("CustomData: ").append(this.getCustomData()).append(",");
        }
        if (this.getBranches() != null) {
            sb.append("Branches: ").append(this.getBranches()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryTrigger)) {
            return false;
        }
        RepositoryTrigger other = (RepositoryTrigger)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDestinationArn() == null ^ this.getDestinationArn() == null) {
            return false;
        }
        if (other.getDestinationArn() != null && !other.getDestinationArn().equals(this.getDestinationArn())) {
            return false;
        }
        if (other.getCustomData() == null ^ this.getCustomData() == null) {
            return false;
        }
        if (other.getCustomData() != null && !other.getCustomData().equals(this.getCustomData())) {
            return false;
        }
        if (other.getBranches() == null ^ this.getBranches() == null) {
            return false;
        }
        if (other.getBranches() != null && !other.getBranches().equals(this.getBranches())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationArn() == null ? 0 : this.getDestinationArn().hashCode());
        hashCode = 31 * hashCode + (this.getCustomData() == null ? 0 : this.getCustomData().hashCode());
        hashCode = 31 * hashCode + (this.getBranches() == null ? 0 : this.getBranches().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public RepositoryTrigger clone() {
        try {
            return (RepositoryTrigger)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryTriggerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

