/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dax.model.Subnet;
import com.amazonaws.services.dax.model.transform.SubnetGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubnetGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String subnetGroupName;
    private String description;
    private String vpcId;
    private List<Subnet> subnets;

    public void setSubnetGroupName(String subnetGroupName) {
        this.subnetGroupName = subnetGroupName;
    }

    public String getSubnetGroupName() {
        return this.subnetGroupName;
    }

    public SubnetGroup withSubnetGroupName(String subnetGroupName) {
        this.setSubnetGroupName(subnetGroupName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SubnetGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public SubnetGroup withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<Subnet> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<Subnet>(subnets);
    }

    public SubnetGroup withSubnets(Subnet ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<Subnet>(subnets.length));
        }
        for (Subnet ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public SubnetGroup withSubnets(Collection<Subnet> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetGroupName() != null) {
            sb.append("SubnetGroupName: ").append(this.getSubnetGroupName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetGroup)) {
            return false;
        }
        SubnetGroup other = (SubnetGroup)obj;
        if (other.getSubnetGroupName() == null ^ this.getSubnetGroupName() == null) {
            return false;
        }
        if (other.getSubnetGroupName() != null && !other.getSubnetGroupName().equals(this.getSubnetGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || other.getSubnets().equals(this.getSubnets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetGroupName() == null ? 0 : this.getSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        return hashCode;
    }

    public SubnetGroup clone() {
        try {
            return (SubnetGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubnetGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

