/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directory.model.Snapshot;
import java.util.Date;

@SdkInternalApi
public class SnapshotMarshaller {
    private static final MarshallingInfo<String> DIRECTORYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryId").build();
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final SnapshotMarshaller instance = new SnapshotMarshaller();

    public static SnapshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(Snapshot snapshot, ProtocolMarshaller protocolMarshaller) {
        if (snapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(snapshot.getDirectoryId(), DIRECTORYID_BINDING);
            protocolMarshaller.marshall(snapshot.getSnapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall(snapshot.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(snapshot.getName(), NAME_BINDING);
            protocolMarshaller.marshall(snapshot.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(snapshot.getStartTime(), STARTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

