/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.transform.AuthorizeSecurityGroupIngressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AuthorizeSecurityGroupIngressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AuthorizeSecurityGroupIngressRequest> {
    private String cidrIp;
    private Integer fromPort;
    private String groupId;
    private String groupName;
    private SdkInternalList<IpPermission> ipPermissions;
    private String ipProtocol;
    private String sourceSecurityGroupName;
    private String sourceSecurityGroupOwnerId;
    private Integer toPort;

    public AuthorizeSecurityGroupIngressRequest() {
    }

    public AuthorizeSecurityGroupIngressRequest(String groupName, List<IpPermission> ipPermissions) {
        this.setGroupName(groupName);
        this.setIpPermissions(ipPermissions);
    }

    public void setCidrIp(String cidrIp) {
        this.cidrIp = cidrIp;
    }

    public String getCidrIp() {
        return this.cidrIp;
    }

    public AuthorizeSecurityGroupIngressRequest withCidrIp(String cidrIp) {
        this.setCidrIp(cidrIp);
        return this;
    }

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public AuthorizeSecurityGroupIngressRequest withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public AuthorizeSecurityGroupIngressRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public AuthorizeSecurityGroupIngressRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new SdkInternalList();
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        this.ipPermissions = new SdkInternalList<IpPermission>(ipPermissions);
    }

    public AuthorizeSecurityGroupIngressRequest withIpPermissions(IpPermission ... ipPermissions) {
        if (this.ipPermissions == null) {
            this.setIpPermissions(new SdkInternalList<IpPermission>(ipPermissions.length));
        }
        for (IpPermission ele : ipPermissions) {
            this.ipPermissions.add(ele);
        }
        return this;
    }

    public AuthorizeSecurityGroupIngressRequest withIpPermissions(Collection<IpPermission> ipPermissions) {
        this.setIpPermissions(ipPermissions);
        return this;
    }

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public AuthorizeSecurityGroupIngressRequest withIpProtocol(String ipProtocol) {
        this.setIpProtocol(ipProtocol);
        return this;
    }

    public void setSourceSecurityGroupName(String sourceSecurityGroupName) {
        this.sourceSecurityGroupName = sourceSecurityGroupName;
    }

    public String getSourceSecurityGroupName() {
        return this.sourceSecurityGroupName;
    }

    public AuthorizeSecurityGroupIngressRequest withSourceSecurityGroupName(String sourceSecurityGroupName) {
        this.setSourceSecurityGroupName(sourceSecurityGroupName);
        return this;
    }

    public void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
        this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
    }

    public String getSourceSecurityGroupOwnerId() {
        return this.sourceSecurityGroupOwnerId;
    }

    public AuthorizeSecurityGroupIngressRequest withSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
        this.setSourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public AuthorizeSecurityGroupIngressRequest withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    @Override
    public Request<AuthorizeSecurityGroupIngressRequest> getDryRunRequest() {
        Request<AuthorizeSecurityGroupIngressRequest> request = new AuthorizeSecurityGroupIngressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCidrIp() != null) {
            sb.append("CidrIp: ").append(this.getCidrIp()).append(",");
        }
        if (this.getFromPort() != null) {
            sb.append("FromPort: ").append(this.getFromPort()).append(",");
        }
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: ").append(this.getIpPermissions()).append(",");
        }
        if (this.getIpProtocol() != null) {
            sb.append("IpProtocol: ").append(this.getIpProtocol()).append(",");
        }
        if (this.getSourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: ").append(this.getSourceSecurityGroupName()).append(",");
        }
        if (this.getSourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: ").append(this.getSourceSecurityGroupOwnerId()).append(",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: ").append(this.getToPort());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupIngressRequest other = (AuthorizeSecurityGroupIngressRequest)obj;
        if (other.getCidrIp() == null ^ this.getCidrIp() == null) {
            return false;
        }
        if (other.getCidrIp() != null && !other.getCidrIp().equals(this.getCidrIp())) {
            return false;
        }
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        if (other.getIpPermissions() != null && !other.getIpPermissions().equals(this.getIpPermissions())) {
            return false;
        }
        if (other.getIpProtocol() == null ^ this.getIpProtocol() == null) {
            return false;
        }
        if (other.getIpProtocol() != null && !other.getIpProtocol().equals(this.getIpProtocol())) {
            return false;
        }
        if (other.getSourceSecurityGroupName() == null ^ this.getSourceSecurityGroupName() == null) {
            return false;
        }
        if (other.getSourceSecurityGroupName() != null && !other.getSourceSecurityGroupName().equals(this.getSourceSecurityGroupName())) {
            return false;
        }
        if (other.getSourceSecurityGroupOwnerId() == null ^ this.getSourceSecurityGroupOwnerId() == null) {
            return false;
        }
        if (other.getSourceSecurityGroupOwnerId() != null && !other.getSourceSecurityGroupOwnerId().equals(this.getSourceSecurityGroupOwnerId())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        return other.getToPort() == null || other.getToPort().equals(this.getToPort());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCidrIp() == null ? 0 : this.getCidrIp().hashCode());
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : this.getIpPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getIpProtocol() == null ? 0 : this.getIpProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroupName() == null ? 0 : this.getSourceSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroupOwnerId() == null ? 0 : this.getSourceSecurityGroupOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        return hashCode;
    }

    @Override
    public AuthorizeSecurityGroupIngressRequest clone() {
        return (AuthorizeSecurityGroupIngressRequest)super.clone();
    }
}

