/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.NetworkBinding;

@SdkInternalApi
public class NetworkBindingMarshaller {
    private static final MarshallingInfo<String> BINDIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bindIP").build();
    private static final MarshallingInfo<Integer> CONTAINERPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPort").build();
    private static final MarshallingInfo<Integer> HOSTPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostPort").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final NetworkBindingMarshaller instance = new NetworkBindingMarshaller();

    public static NetworkBindingMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkBinding networkBinding, ProtocolMarshaller protocolMarshaller) {
        if (networkBinding == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(networkBinding.getBindIP(), BINDIP_BINDING);
            protocolMarshaller.marshall(networkBinding.getContainerPort(), CONTAINERPORT_BINDING);
            protocolMarshaller.marshall(networkBinding.getHostPort(), HOSTPORT_BINDING);
            protocolMarshaller.marshall(networkBinding.getProtocol(), PROTOCOL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

