/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.StepState;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStepsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterId;
    private SdkInternalList<String> stepStates;
    private SdkInternalList<String> stepIds;
    private String marker;

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ListStepsRequest withClusterId(String clusterId) {
        this.setClusterId(clusterId);
        return this;
    }

    public List<String> getStepStates() {
        if (this.stepStates == null) {
            this.stepStates = new SdkInternalList();
        }
        return this.stepStates;
    }

    public void setStepStates(Collection<String> stepStates) {
        if (stepStates == null) {
            this.stepStates = null;
            return;
        }
        this.stepStates = new SdkInternalList<String>(stepStates);
    }

    public ListStepsRequest withStepStates(String ... stepStates) {
        if (this.stepStates == null) {
            this.setStepStates(new SdkInternalList<String>(stepStates.length));
        }
        for (String ele : stepStates) {
            this.stepStates.add(ele);
        }
        return this;
    }

    public ListStepsRequest withStepStates(Collection<String> stepStates) {
        this.setStepStates(stepStates);
        return this;
    }

    public ListStepsRequest withStepStates(StepState ... stepStates) {
        SdkInternalList<String> stepStatesCopy = new SdkInternalList<String>(stepStates.length);
        for (StepState value : stepStates) {
            stepStatesCopy.add(value.toString());
        }
        if (this.getStepStates() == null) {
            this.setStepStates(stepStatesCopy);
        } else {
            this.getStepStates().addAll(stepStatesCopy);
        }
        return this;
    }

    public List<String> getStepIds() {
        if (this.stepIds == null) {
            this.stepIds = new SdkInternalList();
        }
        return this.stepIds;
    }

    public void setStepIds(Collection<String> stepIds) {
        if (stepIds == null) {
            this.stepIds = null;
            return;
        }
        this.stepIds = new SdkInternalList<String>(stepIds);
    }

    public ListStepsRequest withStepIds(String ... stepIds) {
        if (this.stepIds == null) {
            this.setStepIds(new SdkInternalList<String>(stepIds.length));
        }
        for (String ele : stepIds) {
            this.stepIds.add(ele);
        }
        return this;
    }

    public ListStepsRequest withStepIds(Collection<String> stepIds) {
        this.setStepIds(stepIds);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListStepsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterId() != null) {
            sb.append("ClusterId: ").append(this.getClusterId()).append(",");
        }
        if (this.getStepStates() != null) {
            sb.append("StepStates: ").append(this.getStepStates()).append(",");
        }
        if (this.getStepIds() != null) {
            sb.append("StepIds: ").append(this.getStepIds()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsRequest)) {
            return false;
        }
        ListStepsRequest other = (ListStepsRequest)obj;
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getStepStates() == null ^ this.getStepStates() == null) {
            return false;
        }
        if (other.getStepStates() != null && !other.getStepStates().equals(this.getStepStates())) {
            return false;
        }
        if (other.getStepIds() == null ^ this.getStepIds() == null) {
            return false;
        }
        if (other.getStepIds() != null && !other.getStepIds().equals(this.getStepIds())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getStepStates() == null ? 0 : this.getStepStates().hashCode());
        hashCode = 31 * hashCode + (this.getStepIds() == null ? 0 : this.getStepIds().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    @Override
    public ListStepsRequest clone() {
        return (ListStepsRequest)super.clone();
    }
}

