/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.glacier.model.JobParameters;
import java.io.Serializable;

public class InitiateJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private String vaultName;
    private JobParameters jobParameters;

    public InitiateJobRequest() {
    }

    public InitiateJobRequest(String vaultName, JobParameters jobParameters) {
        this.setVaultName(vaultName);
        this.setJobParameters(jobParameters);
    }

    public InitiateJobRequest(String accountId, String vaultName, JobParameters jobParameters) {
        this.setAccountId(accountId);
        this.setVaultName(vaultName);
        this.setJobParameters(jobParameters);
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public InitiateJobRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public InitiateJobRequest withVaultName(String vaultName) {
        this.setVaultName(vaultName);
        return this;
    }

    public void setJobParameters(JobParameters jobParameters) {
        this.jobParameters = jobParameters;
    }

    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    public InitiateJobRequest withJobParameters(JobParameters jobParameters) {
        this.setJobParameters(jobParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getVaultName() != null) {
            sb.append("VaultName: ").append(this.getVaultName()).append(",");
        }
        if (this.getJobParameters() != null) {
            sb.append("JobParameters: ").append(this.getJobParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateJobRequest)) {
            return false;
        }
        InitiateJobRequest other = (InitiateJobRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getVaultName() == null ^ this.getVaultName() == null) {
            return false;
        }
        if (other.getVaultName() != null && !other.getVaultName().equals(this.getVaultName())) {
            return false;
        }
        if (other.getJobParameters() == null ^ this.getJobParameters() == null) {
            return false;
        }
        return other.getJobParameters() == null || other.getJobParameters().equals(this.getJobParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getVaultName() == null ? 0 : this.getVaultName().hashCode());
        hashCode = 31 * hashCode + (this.getJobParameters() == null ? 0 : this.getJobParameters().hashCode());
        return hashCode;
    }

    @Override
    public InitiateJobRequest clone() {
        return (InitiateJobRequest)super.clone();
    }
}

