/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.PartListElement;

@SdkInternalApi
public class PartListElementMarshaller {
    private static final MarshallingInfo<String> RANGEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RangeInBytes").build();
    private static final MarshallingInfo<String> SHA256TREEHASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SHA256TreeHash").build();
    private static final PartListElementMarshaller instance = new PartListElementMarshaller();

    public static PartListElementMarshaller getInstance() {
        return instance;
    }

    public void marshall(PartListElement partListElement, ProtocolMarshaller protocolMarshaller) {
        if (partListElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(partListElement.getRangeInBytes(), RANGEINBYTES_BINDING);
            protocolMarshaller.marshall(partListElement.getSHA256TreeHash(), SHA256TREEHASH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

