/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.InstancePortInfo;
import com.amazonaws.services.lightsail.model.MonthlyTransfer;
import com.amazonaws.services.lightsail.model.transform.InstanceNetworkingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceNetworking
implements Serializable,
Cloneable,
StructuredPojo {
    private MonthlyTransfer monthlyTransfer;
    private List<InstancePortInfo> ports;

    public void setMonthlyTransfer(MonthlyTransfer monthlyTransfer) {
        this.monthlyTransfer = monthlyTransfer;
    }

    public MonthlyTransfer getMonthlyTransfer() {
        return this.monthlyTransfer;
    }

    public InstanceNetworking withMonthlyTransfer(MonthlyTransfer monthlyTransfer) {
        this.setMonthlyTransfer(monthlyTransfer);
        return this;
    }

    public List<InstancePortInfo> getPorts() {
        return this.ports;
    }

    public void setPorts(Collection<InstancePortInfo> ports) {
        if (ports == null) {
            this.ports = null;
            return;
        }
        this.ports = new ArrayList<InstancePortInfo>(ports);
    }

    public InstanceNetworking withPorts(InstancePortInfo ... ports) {
        if (this.ports == null) {
            this.setPorts(new ArrayList<InstancePortInfo>(ports.length));
        }
        for (InstancePortInfo ele : ports) {
            this.ports.add(ele);
        }
        return this;
    }

    public InstanceNetworking withPorts(Collection<InstancePortInfo> ports) {
        this.setPorts(ports);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonthlyTransfer() != null) {
            sb.append("MonthlyTransfer: ").append(this.getMonthlyTransfer()).append(",");
        }
        if (this.getPorts() != null) {
            sb.append("Ports: ").append(this.getPorts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworking)) {
            return false;
        }
        InstanceNetworking other = (InstanceNetworking)obj;
        if (other.getMonthlyTransfer() == null ^ this.getMonthlyTransfer() == null) {
            return false;
        }
        if (other.getMonthlyTransfer() != null && !other.getMonthlyTransfer().equals(this.getMonthlyTransfer())) {
            return false;
        }
        if (other.getPorts() == null ^ this.getPorts() == null) {
            return false;
        }
        return other.getPorts() == null || other.getPorts().equals(this.getPorts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonthlyTransfer() == null ? 0 : this.getMonthlyTransfer().hashCode());
        hashCode = 31 * hashCode + (this.getPorts() == null ? 0 : this.getPorts().hashCode());
        return hashCode;
    }

    public InstanceNetworking clone() {
        try {
            return (InstanceNetworking)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceNetworkingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

