/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.machinelearning.model.RDSDatabase;
import com.amazonaws.services.machinelearning.model.RDSDatabaseCredentials;
import com.amazonaws.services.machinelearning.model.transform.RDSDataSpecMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RDSDataSpec
implements Serializable,
Cloneable,
StructuredPojo {
    private RDSDatabase databaseInformation;
    private String selectSqlQuery;
    private RDSDatabaseCredentials databaseCredentials;
    private String s3StagingLocation;
    private String dataRearrangement;
    private String dataSchema;
    private String dataSchemaUri;
    private String resourceRole;
    private String serviceRole;
    private String subnetId;
    private SdkInternalList<String> securityGroupIds;

    public void setDatabaseInformation(RDSDatabase databaseInformation) {
        this.databaseInformation = databaseInformation;
    }

    public RDSDatabase getDatabaseInformation() {
        return this.databaseInformation;
    }

    public RDSDataSpec withDatabaseInformation(RDSDatabase databaseInformation) {
        this.setDatabaseInformation(databaseInformation);
        return this;
    }

    public void setSelectSqlQuery(String selectSqlQuery) {
        this.selectSqlQuery = selectSqlQuery;
    }

    public String getSelectSqlQuery() {
        return this.selectSqlQuery;
    }

    public RDSDataSpec withSelectSqlQuery(String selectSqlQuery) {
        this.setSelectSqlQuery(selectSqlQuery);
        return this;
    }

    public void setDatabaseCredentials(RDSDatabaseCredentials databaseCredentials) {
        this.databaseCredentials = databaseCredentials;
    }

    public RDSDatabaseCredentials getDatabaseCredentials() {
        return this.databaseCredentials;
    }

    public RDSDataSpec withDatabaseCredentials(RDSDatabaseCredentials databaseCredentials) {
        this.setDatabaseCredentials(databaseCredentials);
        return this;
    }

    public void setS3StagingLocation(String s3StagingLocation) {
        this.s3StagingLocation = s3StagingLocation;
    }

    public String getS3StagingLocation() {
        return this.s3StagingLocation;
    }

    public RDSDataSpec withS3StagingLocation(String s3StagingLocation) {
        this.setS3StagingLocation(s3StagingLocation);
        return this;
    }

    public void setDataRearrangement(String dataRearrangement) {
        this.dataRearrangement = dataRearrangement;
    }

    public String getDataRearrangement() {
        return this.dataRearrangement;
    }

    public RDSDataSpec withDataRearrangement(String dataRearrangement) {
        this.setDataRearrangement(dataRearrangement);
        return this;
    }

    public void setDataSchema(String dataSchema) {
        this.dataSchema = dataSchema;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public RDSDataSpec withDataSchema(String dataSchema) {
        this.setDataSchema(dataSchema);
        return this;
    }

    public void setDataSchemaUri(String dataSchemaUri) {
        this.dataSchemaUri = dataSchemaUri;
    }

    public String getDataSchemaUri() {
        return this.dataSchemaUri;
    }

    public RDSDataSpec withDataSchemaUri(String dataSchemaUri) {
        this.setDataSchemaUri(dataSchemaUri);
        return this;
    }

    public void setResourceRole(String resourceRole) {
        this.resourceRole = resourceRole;
    }

    public String getResourceRole() {
        return this.resourceRole;
    }

    public RDSDataSpec withResourceRole(String resourceRole) {
        this.setResourceRole(resourceRole);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public RDSDataSpec withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public RDSDataSpec withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList<String>(securityGroupIds);
    }

    public RDSDataSpec withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new SdkInternalList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public RDSDataSpec withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseInformation() != null) {
            sb.append("DatabaseInformation: ").append(this.getDatabaseInformation()).append(",");
        }
        if (this.getSelectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.getSelectSqlQuery()).append(",");
        }
        if (this.getDatabaseCredentials() != null) {
            sb.append("DatabaseCredentials: ").append(this.getDatabaseCredentials()).append(",");
        }
        if (this.getS3StagingLocation() != null) {
            sb.append("S3StagingLocation: ").append(this.getS3StagingLocation()).append(",");
        }
        if (this.getDataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.getDataRearrangement()).append(",");
        }
        if (this.getDataSchema() != null) {
            sb.append("DataSchema: ").append(this.getDataSchema()).append(",");
        }
        if (this.getDataSchemaUri() != null) {
            sb.append("DataSchemaUri: ").append(this.getDataSchemaUri()).append(",");
        }
        if (this.getResourceRole() != null) {
            sb.append("ResourceRole: ").append(this.getResourceRole()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDataSpec)) {
            return false;
        }
        RDSDataSpec other = (RDSDataSpec)obj;
        if (other.getDatabaseInformation() == null ^ this.getDatabaseInformation() == null) {
            return false;
        }
        if (other.getDatabaseInformation() != null && !other.getDatabaseInformation().equals(this.getDatabaseInformation())) {
            return false;
        }
        if (other.getSelectSqlQuery() == null ^ this.getSelectSqlQuery() == null) {
            return false;
        }
        if (other.getSelectSqlQuery() != null && !other.getSelectSqlQuery().equals(this.getSelectSqlQuery())) {
            return false;
        }
        if (other.getDatabaseCredentials() == null ^ this.getDatabaseCredentials() == null) {
            return false;
        }
        if (other.getDatabaseCredentials() != null && !other.getDatabaseCredentials().equals(this.getDatabaseCredentials())) {
            return false;
        }
        if (other.getS3StagingLocation() == null ^ this.getS3StagingLocation() == null) {
            return false;
        }
        if (other.getS3StagingLocation() != null && !other.getS3StagingLocation().equals(this.getS3StagingLocation())) {
            return false;
        }
        if (other.getDataRearrangement() == null ^ this.getDataRearrangement() == null) {
            return false;
        }
        if (other.getDataRearrangement() != null && !other.getDataRearrangement().equals(this.getDataRearrangement())) {
            return false;
        }
        if (other.getDataSchema() == null ^ this.getDataSchema() == null) {
            return false;
        }
        if (other.getDataSchema() != null && !other.getDataSchema().equals(this.getDataSchema())) {
            return false;
        }
        if (other.getDataSchemaUri() == null ^ this.getDataSchemaUri() == null) {
            return false;
        }
        if (other.getDataSchemaUri() != null && !other.getDataSchemaUri().equals(this.getDataSchemaUri())) {
            return false;
        }
        if (other.getResourceRole() == null ^ this.getResourceRole() == null) {
            return false;
        }
        if (other.getResourceRole() != null && !other.getResourceRole().equals(this.getResourceRole())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        return other.getSecurityGroupIds() == null || other.getSecurityGroupIds().equals(this.getSecurityGroupIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseInformation() == null ? 0 : this.getDatabaseInformation().hashCode());
        hashCode = 31 * hashCode + (this.getSelectSqlQuery() == null ? 0 : this.getSelectSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseCredentials() == null ? 0 : this.getDatabaseCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getS3StagingLocation() == null ? 0 : this.getS3StagingLocation().hashCode());
        hashCode = 31 * hashCode + (this.getDataRearrangement() == null ? 0 : this.getDataRearrangement().hashCode());
        hashCode = 31 * hashCode + (this.getDataSchema() == null ? 0 : this.getDataSchema().hashCode());
        hashCode = 31 * hashCode + (this.getDataSchemaUri() == null ? 0 : this.getDataSchemaUri().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRole() == null ? 0 : this.getResourceRole().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        return hashCode;
    }

    public RDSDataSpec clone() {
        try {
            return (RDSDataSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

