/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.machinelearning.model.DataSource;
import java.util.Date;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").build();
    private static final MarshallingInfo<String> DATALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocationS3").build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").build();
    private static final MarshallingInfo<Long> DATASIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSizeInBytes").build();
    private static final MarshallingInfo<Long> NUMBEROFFILES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfFiles").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTMETADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftMetadata").build();
    private static final MarshallingInfo<StructuredPojo> RDSMETADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RDSMetadata").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<Boolean> COMPUTESTATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeStatistics").build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").build();
    private static final MarshallingInfo<Date> FINISHEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").build();
    private static final DataSourceMarshaller instance = new DataSourceMarshaller();

    public static DataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        if (dataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataSource.getDataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall(dataSource.getDataLocationS3(), DATALOCATIONS3_BINDING);
            protocolMarshaller.marshall(dataSource.getDataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall(dataSource.getCreatedByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall(dataSource.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(dataSource.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(dataSource.getDataSizeInBytes(), DATASIZEINBYTES_BINDING);
            protocolMarshaller.marshall(dataSource.getNumberOfFiles(), NUMBEROFFILES_BINDING);
            protocolMarshaller.marshall(dataSource.getName(), NAME_BINDING);
            protocolMarshaller.marshall(dataSource.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(dataSource.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall(dataSource.getRedshiftMetadata(), REDSHIFTMETADATA_BINDING);
            protocolMarshaller.marshall(dataSource.getRDSMetadata(), RDSMETADATA_BINDING);
            protocolMarshaller.marshall(dataSource.getRoleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(dataSource.getComputeStatistics(), COMPUTESTATISTICS_BINDING);
            protocolMarshaller.marshall(dataSource.getComputeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall(dataSource.getFinishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall(dataSource.getStartedAt(), STARTEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

