/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobile.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mobile.model.ProjectState;
import com.amazonaws.services.mobile.model.Resource;
import com.amazonaws.services.mobile.model.transform.ProjectDetailsMarshaller;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ProjectDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String projectId;
    private String region;
    private String state;
    private Date createdDate;
    private Date lastUpdatedDate;
    private String consoleUrl;
    private List<Resource> resources;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ProjectDetails withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public ProjectDetails withProjectId(String projectId) {
        this.setProjectId(projectId);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public ProjectDetails withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public ProjectDetails withState(String state) {
        this.setState(state);
        return this;
    }

    public ProjectDetails withState(ProjectState state) {
        this.state = state.toString();
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public ProjectDetails withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setLastUpdatedDate(Date lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public ProjectDetails withLastUpdatedDate(Date lastUpdatedDate) {
        this.setLastUpdatedDate(lastUpdatedDate);
        return this;
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public ProjectDetails withConsoleUrl(String consoleUrl) {
        this.setConsoleUrl(consoleUrl);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public ProjectDetails withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public ProjectDetails withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProjectId() != null) {
            sb.append("ProjectId: ").append(this.getProjectId()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getLastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(this.getLastUpdatedDate()).append(",");
        }
        if (this.getConsoleUrl() != null) {
            sb.append("ConsoleUrl: ").append(this.getConsoleUrl()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDetails)) {
            return false;
        }
        ProjectDetails other = (ProjectDetails)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProjectId() == null ^ this.getProjectId() == null) {
            return false;
        }
        if (other.getProjectId() != null && !other.getProjectId().equals(this.getProjectId())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getLastUpdatedDate() == null ^ this.getLastUpdatedDate() == null) {
            return false;
        }
        if (other.getLastUpdatedDate() != null && !other.getLastUpdatedDate().equals(this.getLastUpdatedDate())) {
            return false;
        }
        if (other.getConsoleUrl() == null ^ this.getConsoleUrl() == null) {
            return false;
        }
        if (other.getConsoleUrl() != null && !other.getConsoleUrl().equals(this.getConsoleUrl())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProjectId() == null ? 0 : this.getProjectId().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedDate() == null ? 0 : this.getLastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getConsoleUrl() == null ? 0 : this.getConsoleUrl().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public ProjectDetails clone() {
        try {
            return (ProjectDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

