/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.DefaultPushNotificationMessage;
import java.util.Map;

@SdkInternalApi
public class DefaultPushNotificationMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> JSONDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JsonData").build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final DefaultPushNotificationMessageMarshaller instance = new DefaultPushNotificationMessageMarshaller();

    public static DefaultPushNotificationMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(DefaultPushNotificationMessage defaultPushNotificationMessage, ProtocolMarshaller protocolMarshaller) {
        if (defaultPushNotificationMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(defaultPushNotificationMessage.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getData(), DATA_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getJsonData(), JSONDATA_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getSilentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall(defaultPushNotificationMessage.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

