/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.EmailMessage;
import java.util.Map;

@SdkInternalApi
public class EmailMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> FROMADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromAddress").build();
    private static final MarshallingInfo<String> HTMLBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HtmlBody").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> TEMPLATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemplateArn").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final EmailMessageMarshaller instance = new EmailMessageMarshaller();

    public static EmailMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(EmailMessage emailMessage, ProtocolMarshaller protocolMarshaller) {
        if (emailMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(emailMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall(emailMessage.getFromAddress(), FROMADDRESS_BINDING);
            protocolMarshaller.marshall(emailMessage.getHtmlBody(), HTMLBODY_BINDING);
            protocolMarshaller.marshall(emailMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall(emailMessage.getTemplateArn(), TEMPLATEARN_BINDING);
            protocolMarshaller.marshall(emailMessage.getTitle(), TITLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

