/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.AddRoleToDBClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AddRoleToDBClusterRequestMarshaller
implements Marshaller<Request<AddRoleToDBClusterRequest>, AddRoleToDBClusterRequest> {
    @Override
    public Request<AddRoleToDBClusterRequest> marshall(AddRoleToDBClusterRequest addRoleToDBClusterRequest) {
        if (addRoleToDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddRoleToDBClusterRequest> request = new DefaultRequest<AddRoleToDBClusterRequest>(addRoleToDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "AddRoleToDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addRoleToDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(addRoleToDBClusterRequest.getDBClusterIdentifier()));
        }
        if (addRoleToDBClusterRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(addRoleToDBClusterRequest.getRoleArn()));
        }
        return request;
    }
}

