/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.Face;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Face> faces;
    private String nextToken;

    public List<Face> getFaces() {
        return this.faces;
    }

    public void setFaces(Collection<Face> faces) {
        if (faces == null) {
            this.faces = null;
            return;
        }
        this.faces = new ArrayList<Face>(faces);
    }

    public ListFacesResult withFaces(Face ... faces) {
        if (this.faces == null) {
            this.setFaces(new ArrayList<Face>(faces.length));
        }
        for (Face ele : faces) {
            this.faces.add(ele);
        }
        return this;
    }

    public ListFacesResult withFaces(Collection<Face> faces) {
        this.setFaces(faces);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFacesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFaces() != null) {
            sb.append("Faces: ").append(this.getFaces()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResult)) {
            return false;
        }
        ListFacesResult other = (ListFacesResult)obj;
        if (other.getFaces() == null ^ this.getFaces() == null) {
            return false;
        }
        if (other.getFaces() != null && !other.getFaces().equals(this.getFaces())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFaces() == null ? 0 : this.getFaces().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFacesResult clone() {
        try {
            return (ListFacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

