/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ResourceRecordStaxUnmarshaller
implements Unmarshaller<ResourceRecord, StaxUnmarshallerContext> {
    private static ResourceRecordStaxUnmarshaller instance;

    @Override
    public ResourceRecord unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceRecord resourceRecord = new ResourceRecord();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceRecord;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Value", targetDepth)) continue;
                resourceRecord.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceRecord;
    }

    public static ResourceRecordStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceRecordStaxUnmarshaller();
        }
        return instance;
    }
}

