/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.DeletableItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchDeleteAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private SdkInternalList<DeletableItem> items;

    public BatchDeleteAttributesRequest() {
    }

    public BatchDeleteAttributesRequest(String domainName, List<DeletableItem> items) {
        this.setDomainName(domainName);
        this.setItems(items);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public BatchDeleteAttributesRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public List<DeletableItem> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<DeletableItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList<DeletableItem>(items);
    }

    public BatchDeleteAttributesRequest withItems(DeletableItem ... items) {
        if (this.items == null) {
            this.setItems(new SdkInternalList<DeletableItem>(items.length));
        }
        for (DeletableItem ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public BatchDeleteAttributesRequest withItems(Collection<DeletableItem> items) {
        this.setItems(items);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAttributesRequest)) {
            return false;
        }
        BatchDeleteAttributesRequest other = (BatchDeleteAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    @Override
    public BatchDeleteAttributesRequest clone() {
        return (BatchDeleteAttributesRequest)super.clone();
    }
}

