/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentType;
import com.amazonaws.services.simplesystemsmanagement.model.PlatformType;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentIdentifierMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DocumentIdentifier
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String owner;
    private SdkInternalList<String> platformTypes;
    private String documentVersion;
    private String documentType;
    private String schemaVersion;
    private SdkInternalList<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentIdentifier withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public DocumentIdentifier withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public List<String> getPlatformTypes() {
        if (this.platformTypes == null) {
            this.platformTypes = new SdkInternalList();
        }
        return this.platformTypes;
    }

    public void setPlatformTypes(Collection<String> platformTypes) {
        if (platformTypes == null) {
            this.platformTypes = null;
            return;
        }
        this.platformTypes = new SdkInternalList<String>(platformTypes);
    }

    public DocumentIdentifier withPlatformTypes(String ... platformTypes) {
        if (this.platformTypes == null) {
            this.setPlatformTypes(new SdkInternalList<String>(platformTypes.length));
        }
        for (String ele : platformTypes) {
            this.platformTypes.add(ele);
        }
        return this;
    }

    public DocumentIdentifier withPlatformTypes(Collection<String> platformTypes) {
        this.setPlatformTypes(platformTypes);
        return this;
    }

    public DocumentIdentifier withPlatformTypes(PlatformType ... platformTypes) {
        SdkInternalList<String> platformTypesCopy = new SdkInternalList<String>(platformTypes.length);
        for (PlatformType value : platformTypes) {
            platformTypesCopy.add(value.toString());
        }
        if (this.getPlatformTypes() == null) {
            this.setPlatformTypes(platformTypesCopy);
        } else {
            this.getPlatformTypes().addAll(platformTypesCopy);
        }
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public DocumentIdentifier withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    @JsonProperty(value="documentType")
    public String getDocumentType() {
        return this.documentType;
    }

    public DocumentIdentifier withDocumentType(String documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    @JsonIgnore
    public void setDocumentType(DocumentType documentType) {
        this.withDocumentType(documentType);
    }

    public DocumentIdentifier withDocumentType(DocumentType documentType) {
        this.documentType = documentType.toString();
        return this;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public DocumentIdentifier withSchemaVersion(String schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public DocumentIdentifier withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public DocumentIdentifier withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getPlatformTypes() != null) {
            sb.append("PlatformTypes: ").append(this.getPlatformTypes()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getDocumentType() != null) {
            sb.append("DocumentType: ").append(this.getDocumentType()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getPlatformTypes() == null ^ this.getPlatformTypes() == null) {
            return false;
        }
        if (other.getPlatformTypes() != null && !other.getPlatformTypes().equals(this.getPlatformTypes())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getDocumentType() == null ^ this.getDocumentType() == null) {
            return false;
        }
        if (other.getDocumentType() != null && !other.getDocumentType().equals(this.getDocumentType())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        if (other.getSchemaVersion() != null && !other.getSchemaVersion().equals(this.getSchemaVersion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformTypes() == null ? 0 : this.getPlatformTypes().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentType() == null ? 0 : this.getDocumentType().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DocumentIdentifier clone() {
        try {
            return (DocumentIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

