/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    @Override
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        SdkInternalList actionNamesList;
        SdkInternalList aWSAccountIdsList;
        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "AmazonSNS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPermissionRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(addPermissionRequest.getTopicArn()));
        }
        if (addPermissionRequest.getLabel() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.getLabel()));
        }
        if (!(aWSAccountIdsList = (SdkInternalList)addPermissionRequest.getAWSAccountIds()).isEmpty() || !aWSAccountIdsList.isAutoConstruct()) {
            int aWSAccountIdsListIndex = 1;
            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex, StringUtils.fromString(aWSAccountIdsListValue));
                }
                ++aWSAccountIdsListIndex;
            }
        }
        if (!(actionNamesList = (SdkInternalList)addPermissionRequest.getActionNames()).isEmpty() || !actionNamesList.isAutoConstruct()) {
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionName.member." + actionNamesListIndex, StringUtils.fromString(actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        return request;
    }
}

