/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.workdocs.model.ResourcePath;
import java.util.List;

@SdkInternalApi
public class ResourcePathMarshaller {
    private static final MarshallingInfo<List> COMPONENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Components").build();
    private static final ResourcePathMarshaller instance = new ResourcePathMarshaller();

    public static ResourcePathMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourcePath resourcePath, ProtocolMarshaller protocolMarshaller) {
        if (resourcePath == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourcePath.getComponents(), COMPONENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

