/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.Edge;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EdgeMarshaller {
    private static final MarshallingInfo<Integer> REFERENCEID_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<StructuredPojo> SUMMARYSTATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SummaryStatistics").build();
    private static final MarshallingInfo<List> RESPONSETIMEHISTOGRAM_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTimeHistogram").build();
    private static final MarshallingInfo<List> ALIASES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aliases").build();
    private static final EdgeMarshaller instance = new EdgeMarshaller();

    public static EdgeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Edge edge, ProtocolMarshaller protocolMarshaller) {
        if (edge == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(edge.getReferenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall(edge.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(edge.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(edge.getSummaryStatistics(), SUMMARYSTATISTICS_BINDING);
            protocolMarshaller.marshall(edge.getResponseTimeHistogram(), RESPONSETIMEHISTOGRAM_BINDING);
            protocolMarshaller.marshall(edge.getAliases(), ALIASES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

