/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.outposts.AWSOutpostsAsync;
import com.amazonaws.services.outposts.AWSOutpostsAsyncClientBuilder;
import com.amazonaws.services.outposts.AWSOutpostsClient;
import com.amazonaws.services.outposts.model.CreateOrderRequest;
import com.amazonaws.services.outposts.model.CreateOrderResult;
import com.amazonaws.services.outposts.model.CreateOutpostRequest;
import com.amazonaws.services.outposts.model.CreateOutpostResult;
import com.amazonaws.services.outposts.model.DeleteOutpostRequest;
import com.amazonaws.services.outposts.model.DeleteOutpostResult;
import com.amazonaws.services.outposts.model.DeleteSiteRequest;
import com.amazonaws.services.outposts.model.DeleteSiteResult;
import com.amazonaws.services.outposts.model.GetOutpostInstanceTypesRequest;
import com.amazonaws.services.outposts.model.GetOutpostInstanceTypesResult;
import com.amazonaws.services.outposts.model.GetOutpostRequest;
import com.amazonaws.services.outposts.model.GetOutpostResult;
import com.amazonaws.services.outposts.model.ListOutpostsRequest;
import com.amazonaws.services.outposts.model.ListOutpostsResult;
import com.amazonaws.services.outposts.model.ListSitesRequest;
import com.amazonaws.services.outposts.model.ListSitesResult;
import com.amazonaws.services.outposts.model.ListTagsForResourceRequest;
import com.amazonaws.services.outposts.model.ListTagsForResourceResult;
import com.amazonaws.services.outposts.model.TagResourceRequest;
import com.amazonaws.services.outposts.model.TagResourceResult;
import com.amazonaws.services.outposts.model.UntagResourceRequest;
import com.amazonaws.services.outposts.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSOutpostsAsyncClient
extends AWSOutpostsClient
implements AWSOutpostsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSOutpostsAsyncClientBuilder asyncBuilder() {
        return AWSOutpostsAsyncClientBuilder.standard();
    }

    AWSOutpostsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSOutpostsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateOrderResult> createOrderAsync(CreateOrderRequest request) {
        return this.createOrderAsync(request, null);
    }

    @Override
    public Future<CreateOrderResult> createOrderAsync(CreateOrderRequest request, final AsyncHandler<CreateOrderRequest, CreateOrderResult> asyncHandler) {
        final CreateOrderRequest finalRequest = (CreateOrderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOrderResult>(){

            @Override
            public CreateOrderResult call() throws Exception {
                CreateOrderResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCreateOrder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOutpostResult> createOutpostAsync(CreateOutpostRequest request) {
        return this.createOutpostAsync(request, null);
    }

    @Override
    public Future<CreateOutpostResult> createOutpostAsync(CreateOutpostRequest request, final AsyncHandler<CreateOutpostRequest, CreateOutpostResult> asyncHandler) {
        final CreateOutpostRequest finalRequest = (CreateOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOutpostResult>(){

            @Override
            public CreateOutpostResult call() throws Exception {
                CreateOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCreateOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOutpostResult> deleteOutpostAsync(DeleteOutpostRequest request) {
        return this.deleteOutpostAsync(request, null);
    }

    @Override
    public Future<DeleteOutpostResult> deleteOutpostAsync(DeleteOutpostRequest request, final AsyncHandler<DeleteOutpostRequest, DeleteOutpostResult> asyncHandler) {
        final DeleteOutpostRequest finalRequest = (DeleteOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOutpostResult>(){

            @Override
            public DeleteOutpostResult call() throws Exception {
                DeleteOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeDeleteOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request) {
        return this.deleteSiteAsync(request, null);
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request, final AsyncHandler<DeleteSiteRequest, DeleteSiteResult> asyncHandler) {
        final DeleteSiteRequest finalRequest = (DeleteSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSiteResult>(){

            @Override
            public DeleteSiteResult call() throws Exception {
                DeleteSiteResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeDeleteSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutpostResult> getOutpostAsync(GetOutpostRequest request) {
        return this.getOutpostAsync(request, null);
    }

    @Override
    public Future<GetOutpostResult> getOutpostAsync(GetOutpostRequest request, final AsyncHandler<GetOutpostRequest, GetOutpostResult> asyncHandler) {
        final GetOutpostRequest finalRequest = (GetOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutpostResult>(){

            @Override
            public GetOutpostResult call() throws Exception {
                GetOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutpostInstanceTypesResult> getOutpostInstanceTypesAsync(GetOutpostInstanceTypesRequest request) {
        return this.getOutpostInstanceTypesAsync(request, null);
    }

    @Override
    public Future<GetOutpostInstanceTypesResult> getOutpostInstanceTypesAsync(GetOutpostInstanceTypesRequest request, final AsyncHandler<GetOutpostInstanceTypesRequest, GetOutpostInstanceTypesResult> asyncHandler) {
        final GetOutpostInstanceTypesRequest finalRequest = (GetOutpostInstanceTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutpostInstanceTypesResult>(){

            @Override
            public GetOutpostInstanceTypesResult call() throws Exception {
                GetOutpostInstanceTypesResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetOutpostInstanceTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOutpostsResult> listOutpostsAsync(ListOutpostsRequest request) {
        return this.listOutpostsAsync(request, null);
    }

    @Override
    public Future<ListOutpostsResult> listOutpostsAsync(ListOutpostsRequest request, final AsyncHandler<ListOutpostsRequest, ListOutpostsResult> asyncHandler) {
        final ListOutpostsRequest finalRequest = (ListOutpostsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOutpostsResult>(){

            @Override
            public ListOutpostsResult call() throws Exception {
                ListOutpostsResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListOutposts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSitesResult> listSitesAsync(ListSitesRequest request) {
        return this.listSitesAsync(request, null);
    }

    @Override
    public Future<ListSitesResult> listSitesAsync(ListSitesRequest request, final AsyncHandler<ListSitesRequest, ListSitesResult> asyncHandler) {
        final ListSitesRequest finalRequest = (ListSitesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSitesResult>(){

            @Override
            public ListSitesResult call() throws Exception {
                ListSitesResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListSites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

