/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.outposts.model.Address;
import com.amazonaws.services.outposts.model.RackPhysicalProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateSiteRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String notes;
    private Map<String, String> tags;
    private Address operatingAddress;
    private Address shippingAddress;
    private RackPhysicalProperties rackPhysicalProperties;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateSiteRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateSiteRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public CreateSiteRequest withNotes(String notes) {
        this.setNotes(notes);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateSiteRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateSiteRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateSiteRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setOperatingAddress(Address operatingAddress) {
        this.operatingAddress = operatingAddress;
    }

    public Address getOperatingAddress() {
        return this.operatingAddress;
    }

    public CreateSiteRequest withOperatingAddress(Address operatingAddress) {
        this.setOperatingAddress(operatingAddress);
        return this;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public CreateSiteRequest withShippingAddress(Address shippingAddress) {
        this.setShippingAddress(shippingAddress);
        return this;
    }

    public void setRackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
        this.rackPhysicalProperties = rackPhysicalProperties;
    }

    public RackPhysicalProperties getRackPhysicalProperties() {
        return this.rackPhysicalProperties;
    }

    public CreateSiteRequest withRackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
        this.setRackPhysicalProperties(rackPhysicalProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getNotes() != null) {
            sb.append("Notes: ").append(this.getNotes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getOperatingAddress() != null) {
            sb.append("OperatingAddress: ").append(this.getOperatingAddress()).append(",");
        }
        if (this.getShippingAddress() != null) {
            sb.append("ShippingAddress: ").append(this.getShippingAddress()).append(",");
        }
        if (this.getRackPhysicalProperties() != null) {
            sb.append("RackPhysicalProperties: ").append(this.getRackPhysicalProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSiteRequest)) {
            return false;
        }
        CreateSiteRequest other = (CreateSiteRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getNotes() == null ^ this.getNotes() == null) {
            return false;
        }
        if (other.getNotes() != null && !other.getNotes().equals(this.getNotes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getOperatingAddress() == null ^ this.getOperatingAddress() == null) {
            return false;
        }
        if (other.getOperatingAddress() != null && !other.getOperatingAddress().equals(this.getOperatingAddress())) {
            return false;
        }
        if (other.getShippingAddress() == null ^ this.getShippingAddress() == null) {
            return false;
        }
        if (other.getShippingAddress() != null && !other.getShippingAddress().equals(this.getShippingAddress())) {
            return false;
        }
        if (other.getRackPhysicalProperties() == null ^ this.getRackPhysicalProperties() == null) {
            return false;
        }
        return other.getRackPhysicalProperties() == null || other.getRackPhysicalProperties().equals(this.getRackPhysicalProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getNotes() == null ? 0 : this.getNotes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingAddress() == null ? 0 : this.getOperatingAddress().hashCode());
        hashCode = 31 * hashCode + (this.getShippingAddress() == null ? 0 : this.getShippingAddress().hashCode());
        hashCode = 31 * hashCode + (this.getRackPhysicalProperties() == null ? 0 : this.getRackPhysicalProperties().hashCode());
        return hashCode;
    }

    public CreateSiteRequest clone() {
        return (CreateSiteRequest)super.clone();
    }
}

