/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.ConnectionDetails;
import java.util.List;

@SdkInternalApi
public class ConnectionDetailsMarshaller {
    private static final MarshallingInfo<String> CLIENTPUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientPublicKey").build();
    private static final MarshallingInfo<String> SERVERPUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerPublicKey").build();
    private static final MarshallingInfo<String> SERVERENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerEndpoint").build();
    private static final MarshallingInfo<String> CLIENTTUNNELADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientTunnelAddress").build();
    private static final MarshallingInfo<String> SERVERTUNNELADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerTunnelAddress").build();
    private static final MarshallingInfo<List> ALLOWEDIPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedIps").build();
    private static final ConnectionDetailsMarshaller instance = new ConnectionDetailsMarshaller();

    public static ConnectionDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectionDetails connectionDetails, ProtocolMarshaller protocolMarshaller) {
        if (connectionDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connectionDetails.getClientPublicKey(), CLIENTPUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)connectionDetails.getServerPublicKey(), SERVERPUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)connectionDetails.getServerEndpoint(), SERVERENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)connectionDetails.getClientTunnelAddress(), CLIENTTUNNELADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connectionDetails.getServerTunnelAddress(), SERVERTUNNELADDRESS_BINDING);
            protocolMarshaller.marshall(connectionDetails.getAllowedIps(), ALLOWEDIPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

