/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.panorama.model.transform.PackageObjectMarshaller;
import java.io.Serializable;

public class PackageObject
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String packageVersion;
    private String patchVersion;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PackageObject withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public PackageObject withPackageVersion(String packageVersion) {
        this.setPackageVersion(packageVersion);
        return this;
    }

    public void setPatchVersion(String patchVersion) {
        this.patchVersion = patchVersion;
    }

    public String getPatchVersion() {
        return this.patchVersion;
    }

    public PackageObject withPatchVersion(String patchVersion) {
        this.setPatchVersion(patchVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPackageVersion() != null) {
            sb.append("PackageVersion: ").append(this.getPackageVersion()).append(",");
        }
        if (this.getPatchVersion() != null) {
            sb.append("PatchVersion: ").append(this.getPatchVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageObject)) {
            return false;
        }
        PackageObject other = (PackageObject)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPackageVersion() == null ^ this.getPackageVersion() == null) {
            return false;
        }
        if (other.getPackageVersion() != null && !other.getPackageVersion().equals(this.getPackageVersion())) {
            return false;
        }
        if (other.getPatchVersion() == null ^ this.getPatchVersion() == null) {
            return false;
        }
        return other.getPatchVersion() == null || other.getPatchVersion().equals(this.getPatchVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPackageVersion() == null ? 0 : this.getPackageVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPatchVersion() == null ? 0 : this.getPatchVersion().hashCode());
        return hashCode;
    }

    public PackageObject clone() {
        try {
            return (PackageObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

