/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.BatchArrayProperties;
import com.amazonaws.services.pipes.model.BatchContainerOverrides;
import com.amazonaws.services.pipes.model.BatchJobDependency;
import com.amazonaws.services.pipes.model.BatchRetryStrategy;
import com.amazonaws.services.pipes.model.transform.PipeTargetBatchJobParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PipeTargetBatchJobParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private BatchArrayProperties arrayProperties;
    private BatchContainerOverrides containerOverrides;
    private List<BatchJobDependency> dependsOn;
    private String jobDefinition;
    private String jobName;
    private Map<String, String> parameters;
    private BatchRetryStrategy retryStrategy;

    public void setArrayProperties(BatchArrayProperties arrayProperties) {
        this.arrayProperties = arrayProperties;
    }

    public BatchArrayProperties getArrayProperties() {
        return this.arrayProperties;
    }

    public PipeTargetBatchJobParameters withArrayProperties(BatchArrayProperties arrayProperties) {
        this.setArrayProperties(arrayProperties);
        return this;
    }

    public void setContainerOverrides(BatchContainerOverrides containerOverrides) {
        this.containerOverrides = containerOverrides;
    }

    public BatchContainerOverrides getContainerOverrides() {
        return this.containerOverrides;
    }

    public PipeTargetBatchJobParameters withContainerOverrides(BatchContainerOverrides containerOverrides) {
        this.setContainerOverrides(containerOverrides);
        return this;
    }

    public List<BatchJobDependency> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Collection<BatchJobDependency> dependsOn) {
        if (dependsOn == null) {
            this.dependsOn = null;
            return;
        }
        this.dependsOn = new ArrayList<BatchJobDependency>(dependsOn);
    }

    public PipeTargetBatchJobParameters withDependsOn(BatchJobDependency ... dependsOn) {
        if (this.dependsOn == null) {
            this.setDependsOn(new ArrayList<BatchJobDependency>(dependsOn.length));
        }
        for (BatchJobDependency ele : dependsOn) {
            this.dependsOn.add(ele);
        }
        return this;
    }

    public PipeTargetBatchJobParameters withDependsOn(Collection<BatchJobDependency> dependsOn) {
        this.setDependsOn(dependsOn);
        return this;
    }

    public void setJobDefinition(String jobDefinition) {
        this.jobDefinition = jobDefinition;
    }

    public String getJobDefinition() {
        return this.jobDefinition;
    }

    public PipeTargetBatchJobParameters withJobDefinition(String jobDefinition) {
        this.setJobDefinition(jobDefinition);
        return this;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public PipeTargetBatchJobParameters withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public PipeTargetBatchJobParameters withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public PipeTargetBatchJobParameters addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public PipeTargetBatchJobParameters clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setRetryStrategy(BatchRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public BatchRetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public PipeTargetBatchJobParameters withRetryStrategy(BatchRetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArrayProperties() != null) {
            sb.append("ArrayProperties: ").append(this.getArrayProperties()).append(",");
        }
        if (this.getContainerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(this.getContainerOverrides()).append(",");
        }
        if (this.getDependsOn() != null) {
            sb.append("DependsOn: ").append(this.getDependsOn()).append(",");
        }
        if (this.getJobDefinition() != null) {
            sb.append("JobDefinition: ").append(this.getJobDefinition()).append(",");
        }
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetBatchJobParameters)) {
            return false;
        }
        PipeTargetBatchJobParameters other = (PipeTargetBatchJobParameters)obj;
        if (other.getArrayProperties() == null ^ this.getArrayProperties() == null) {
            return false;
        }
        if (other.getArrayProperties() != null && !other.getArrayProperties().equals(this.getArrayProperties())) {
            return false;
        }
        if (other.getContainerOverrides() == null ^ this.getContainerOverrides() == null) {
            return false;
        }
        if (other.getContainerOverrides() != null && !other.getContainerOverrides().equals(this.getContainerOverrides())) {
            return false;
        }
        if (other.getDependsOn() == null ^ this.getDependsOn() == null) {
            return false;
        }
        if (other.getDependsOn() != null && !other.getDependsOn().equals(this.getDependsOn())) {
            return false;
        }
        if (other.getJobDefinition() == null ^ this.getJobDefinition() == null) {
            return false;
        }
        if (other.getJobDefinition() != null && !other.getJobDefinition().equals(this.getJobDefinition())) {
            return false;
        }
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        return other.getRetryStrategy() == null || other.getRetryStrategy().equals(this.getRetryStrategy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArrayProperties() == null ? 0 : this.getArrayProperties().hashCode());
        hashCode = 31 * hashCode + (this.getContainerOverrides() == null ? 0 : this.getContainerOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getDependsOn() == null ? 0 : this.getDependsOn().hashCode());
        hashCode = 31 * hashCode + (this.getJobDefinition() == null ? 0 : this.getJobDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        return hashCode;
    }

    public PipeTargetBatchJobParameters clone() {
        try {
            return (PipeTargetBatchJobParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipeTargetBatchJobParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

