/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.S3OutputFormat;
import com.amazonaws.services.pipes.model.transform.S3LogDestinationMarshaller;
import java.io.Serializable;

public class S3LogDestination
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String bucketOwner;
    private String outputFormat;
    private String prefix;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3LogDestination withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setBucketOwner(String bucketOwner) {
        this.bucketOwner = bucketOwner;
    }

    public String getBucketOwner() {
        return this.bucketOwner;
    }

    public S3LogDestination withBucketOwner(String bucketOwner) {
        this.setBucketOwner(bucketOwner);
        return this;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public S3LogDestination withOutputFormat(String outputFormat) {
        this.setOutputFormat(outputFormat);
        return this;
    }

    public S3LogDestination withOutputFormat(S3OutputFormat outputFormat) {
        this.outputFormat = outputFormat.toString();
        return this;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public S3LogDestination withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getBucketOwner() != null) {
            sb.append("BucketOwner: ").append(this.getBucketOwner()).append(",");
        }
        if (this.getOutputFormat() != null) {
            sb.append("OutputFormat: ").append(this.getOutputFormat()).append(",");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix: ").append(this.getPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogDestination)) {
            return false;
        }
        S3LogDestination other = (S3LogDestination)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getBucketOwner() == null ^ this.getBucketOwner() == null) {
            return false;
        }
        if (other.getBucketOwner() != null && !other.getBucketOwner().equals(this.getBucketOwner())) {
            return false;
        }
        if (other.getOutputFormat() == null ^ this.getOutputFormat() == null) {
            return false;
        }
        if (other.getOutputFormat() != null && !other.getOutputFormat().equals(this.getOutputFormat())) {
            return false;
        }
        if (other.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        return other.getPrefix() == null || other.getPrefix().equals(this.getPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getBucketOwner() == null ? 0 : this.getBucketOwner().hashCode());
        hashCode = 31 * hashCode + (this.getOutputFormat() == null ? 0 : this.getOutputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        return hashCode;
    }

    public S3LogDestination clone() {
        try {
            return (S3LogDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LogDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

