/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.proton.model.ServiceInstanceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServiceInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ServiceInstanceSummary> serviceInstances;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServiceInstancesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ServiceInstanceSummary> getServiceInstances() {
        return this.serviceInstances;
    }

    public void setServiceInstances(Collection<ServiceInstanceSummary> serviceInstances) {
        if (serviceInstances == null) {
            this.serviceInstances = null;
            return;
        }
        this.serviceInstances = new ArrayList<ServiceInstanceSummary>(serviceInstances);
    }

    public ListServiceInstancesResult withServiceInstances(ServiceInstanceSummary ... serviceInstances) {
        if (this.serviceInstances == null) {
            this.setServiceInstances(new ArrayList<ServiceInstanceSummary>(serviceInstances.length));
        }
        for (ServiceInstanceSummary ele : serviceInstances) {
            this.serviceInstances.add(ele);
        }
        return this;
    }

    public ListServiceInstancesResult withServiceInstances(Collection<ServiceInstanceSummary> serviceInstances) {
        this.setServiceInstances(serviceInstances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getServiceInstances() != null) {
            sb.append("ServiceInstances: ").append(this.getServiceInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceInstancesResult)) {
            return false;
        }
        ListServiceInstancesResult other = (ListServiceInstancesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getServiceInstances() == null ^ this.getServiceInstances() == null) {
            return false;
        }
        return other.getServiceInstances() == null || other.getServiceInstances().equals(this.getServiceInstances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getServiceInstances() == null ? 0 : this.getServiceInstances().hashCode());
        return hashCode;
    }

    public ListServiceInstancesResult clone() {
        try {
            return (ListServiceInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

