/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qapps.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qapps.model.CardInput;
import com.amazonaws.services.qapps.model.transform.AppDefinitionInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AppDefinitionInput
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CardInput> cards;
    private String initialPrompt;

    public List<CardInput> getCards() {
        return this.cards;
    }

    public void setCards(Collection<CardInput> cards) {
        if (cards == null) {
            this.cards = null;
            return;
        }
        this.cards = new ArrayList<CardInput>(cards);
    }

    public AppDefinitionInput withCards(CardInput ... cards) {
        if (this.cards == null) {
            this.setCards(new ArrayList<CardInput>(cards.length));
        }
        for (CardInput ele : cards) {
            this.cards.add(ele);
        }
        return this;
    }

    public AppDefinitionInput withCards(Collection<CardInput> cards) {
        this.setCards(cards);
        return this;
    }

    public void setInitialPrompt(String initialPrompt) {
        this.initialPrompt = initialPrompt;
    }

    public String getInitialPrompt() {
        return this.initialPrompt;
    }

    public AppDefinitionInput withInitialPrompt(String initialPrompt) {
        this.setInitialPrompt(initialPrompt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCards() != null) {
            sb.append("Cards: ").append(this.getCards()).append(",");
        }
        if (this.getInitialPrompt() != null) {
            sb.append("InitialPrompt: ").append(this.getInitialPrompt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDefinitionInput)) {
            return false;
        }
        AppDefinitionInput other = (AppDefinitionInput)obj;
        if (other.getCards() == null ^ this.getCards() == null) {
            return false;
        }
        if (other.getCards() != null && !other.getCards().equals(this.getCards())) {
            return false;
        }
        if (other.getInitialPrompt() == null ^ this.getInitialPrompt() == null) {
            return false;
        }
        return other.getInitialPrompt() == null || other.getInitialPrompt().equals(this.getInitialPrompt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCards() == null ? 0 : this.getCards().hashCode());
        hashCode = 31 * hashCode + (this.getInitialPrompt() == null ? 0 : this.getInitialPrompt().hashCode());
        return hashCode;
    }

    public AppDefinitionInput clone() {
        try {
            return (AppDefinitionInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppDefinitionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

